/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.applaunch.config.core.ConfigHandle;
import org.spongepowered.common.bridge.client.MinecraftBridge;
import org.spongepowered.common.client.SpongeClient;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.launch.Lifecycle;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin
extends ReentrantBlockableEventLoop<Runnable>
implements MinecraftBridge,
SpongeClient {
    @Shadow
    private Thread gameThread;
    @Shadow
    private @Nullable IntegratedServer singleplayerServer;
    private IntegratedServer impl$temporaryIntegratedServer;

    @Shadow
    public abstract boolean renderOnThread();

    @Shadow
    public abstract void pauseGame(boolean var1);

    public MinecraftMixin(String param0) {
        super(param0);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void impl$setClientOnGame(GameConfig gameConfig, CallbackInfo ci) {
        SpongeCommon.game().setClient(this);
    }

    @Inject(method={"run"}, at={@At(value="HEAD")})
    private void impl$setThreadOnClientPhaseTracker(CallbackInfo ci) {
        try {
            PhaseTracker.CLIENT.setThread(this.gameThread);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not initialize the client PhaseTracker!");
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$callStartedEngineAndLoadedGame(CallbackInfo ci) {
        ConfigHandle.setSaveSuppressed(false);
        Lifecycle lifecycle = ((Launch)Launch.instance()).lifecycle();
        lifecycle.callStartedEngineEvent(this);
        lifecycle.callLoadedGameEvent();
    }

    @Redirect(method={"runTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;runAllTasks()V"))
    private void impl$tickClientScheduler(Minecraft minecraft) {
        this.scheduler().tick();
        this.runAllTasks();
    }

    @Override
    public IntegratedServer bridge$getTemporaryIntegratedServer() {
        return this.impl$temporaryIntegratedServer;
    }

    @Override
    public void bridge$setTemporaryIntegratedServer(IntegratedServer server) {
        this.impl$temporaryIntegratedServer = server;
    }

    @Inject(method={"destroy"}, at={@At(value="HEAD")})
    private void impl$callStoppingEngineEvent(CallbackInfo ci) {
        ((Launch)Launch.instance()).lifecycle().callStoppingEngineEvent(this);
    }

    @Redirect(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;singleplayerServer:Lnet/minecraft/client/server/IntegratedServer;", opcode=181))
    private void impl$storeTemporaryServerRef(Minecraft minecraft, IntegratedServer server) {
        ((MinecraftBridge)minecraft).bridge$setTemporaryIntegratedServer(this.singleplayerServer);
        this.singleplayerServer = null;
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="TAIL")})
    private void impl$nullServerRefAndPhaseTracker(Screen screenIn, CallbackInfo ci) {
        this.bridge$setTemporaryIntegratedServer(null);
        try {
            PhaseTracker.SERVER.setThread(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Inject(method={"close"}, at={@At(value="INVOKE", target="Lnet/minecraft/Util;shutdownExecutors()V")})
    private void impl$callStoppedGame(CallbackInfo ci) {
        ((Launch)Launch.instance()).lifecycle().callStoppedGameEvent();
    }
}

