/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import com.google.inject.Injector;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.ProgressListener;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.UnloadWorldEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectProxy;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.commands.CommandSourceBridge;
import org.spongepowered.common.bridge.commands.CommandSourceProviderBridge;
import org.spongepowered.common.bridge.network.chat.SpongeChatDecorator;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.server.players.GameProfileCacheBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.datapack.SpongeDataPackManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.service.server.SpongeServerScopedServiceProvider;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
implements SpongeServer,
MinecraftServerBridge,
CommandSourceProviderBridge,
SubjectProxy,
CommandSourceBridge {
    @Shadow
    @Final
    private Map<ResourceKey<Level>, ServerLevel> levels;
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    private int tickCount;
    @Shadow
    @Final
    protected LevelStorageSource.LevelStorageAccess storageSource;
    @Shadow
    @Final
    private Thread serverThread;
    @Shadow
    private volatile boolean isSaving;
    private final ChatDecorator impl$spongeDecorator = new SpongeChatDecorator();
    private @Nullable SpongeServerScopedServiceProvider impl$serviceProvider;
    protected @Nullable ResourcePackRequest impl$resourcePack;
    private final BlockableEventLoop<Runnable> impl$spongeMainThreadExecutor = new BlockableEventLoop<Runnable>("Sponge"){

        protected @NonNull Runnable wrapRunnable(@NonNull Runnable runnable) {
            return runnable;
        }

        protected boolean shouldRun(@NonNull Runnable runnable) {
            return MinecraftServerMixin.this.shadow$haveTime();
        }

        protected @NonNull Thread getRunningThread() {
            return MinecraftServerMixin.this.serverThread;
        }
    };

    @Shadow
    public abstract CommandSourceStack shadow$createCommandSourceStack();

    @Shadow
    public abstract Iterable<ServerLevel> shadow$getAllLevels();

    @Shadow
    public abstract boolean shadow$isDedicatedServer();

    @Shadow
    public abstract boolean shadow$isRunning();

    @Shadow
    public abstract PlayerList shadow$getPlayerList();

    @Shadow
    public abstract PackRepository shadow$getPackRepository();

    @Shadow
    public abstract RegistryAccess.Frozen shadow$registryAccess();

    @Shadow
    public abstract GameProfileCache shadow$getProfileCache();

    @Shadow
    public abstract CompletableFuture<Void> shadow$reloadResources(Collection<String> var1);

    @Shadow
    public abstract WorldData shadow$getWorldData();

    @Shadow
    protected abstract void loadLevel();

    @Shadow
    public abstract boolean shadow$haveTime();

    @Override
    public Subject subject() {
        return SpongeCommon.game().systemSubject();
    }

    @Inject(method={"spin"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private static void impl$setThreadOnServerPhaseTracker(Function<Thread, MinecraftServer> p_240784_0_, CallbackInfoReturnable<MinecraftServerMixin> cir, AtomicReference<MinecraftServer> atomicReference, Thread thread) {
        try {
            PhaseTracker.SERVER.setThread(thread);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not initialize the server PhaseTracker!");
        }
    }

    @Override
    public ResourcePackRequest bridge$getResourcePack() {
        return this.impl$resourcePack;
    }

    @Inject(method={"tickServer"}, at={@At(value="HEAD")})
    private void impl$onServerTickStart(CallbackInfo ci) {
        this.scheduler().tick();
    }

    @Override
    public CommandSourceStack bridge$getCommandSource(Cause cause) {
        return this.shadow$createCommandSourceStack();
    }

    @Override
    public void bridge$addToCauseStack(CauseStackManager.StackFrame frame) {
        frame.pushCause(Sponge.systemSubject());
    }

    @Overwrite
    @DontObfuscate
    public String getServerModName() {
        return "sponge";
    }

    @Inject(method={"stopServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;saveAllChunks(ZZZ)Z")})
    private void impl$callUnloadWorldEvents(CallbackInfo ci) {
        for (ServerLevel level : this.shadow$getAllLevels()) {
            UnloadWorldEvent unloadWorldEvent = SpongeEventFactory.createUnloadWorldEvent(PhaseTracker.getCauseStackManager().currentCause(), (ServerWorld)level);
            SpongeCommon.post(unloadWorldEvent);
        }
    }

    @Inject(method={"stopServer"}, at={@At(value="TAIL")})
    private void impl$closeLevelSaveForOtherWorlds(CallbackInfo ci) {
        for (Map.Entry<ResourceKey<Level>, ServerLevel> entry : this.levels.entrySet()) {
            if (entry.getKey() == Level.OVERWORLD) continue;
            LevelStorageSource.LevelStorageAccess levelSave = ((ServerLevelBridge)entry.getValue()).bridge$getLevelSave();
            try {
                levelSave.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to unlock level {}", (Object)levelSave.getLevelId(), (Object)e);
            }
        }
    }

    @Inject(method={"sendSystemMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$useTranslatingLogger(Component input, CallbackInfo ci) {
        LOGGER.info(input.getString());
        ci.cancel();
    }

    @ModifyConstant(method={"tickServer"}, constant={@Constant(intValue=0, ordinal=0)})
    private int getSaveTickInterval(int zero) {
        if (!this.shadow$isDedicatedServer()) {
            return zero;
        }
        if (!this.shadow$isRunning()) {
            return Integer.MAX_VALUE;
        }
        int autoPlayerSaveInterval = SpongeConfigs.getCommon().get().world.playerAutoSaveInterval;
        if (autoPlayerSaveInterval > 0 && this.tickCount % autoPlayerSaveInterval == 0) {
            this.isSaving = true;
            this.shadow$getPlayerList().saveAll();
            this.isSaving = false;
        }
        this.isSaving = true;
        this.saveAllChunks(true, false, false);
        this.isSaving = false;
        return Integer.MAX_VALUE;
    }

    @Overwrite
    public boolean saveAllChunks(boolean suppressLog, boolean flush, boolean isForced) {
        boolean var0 = false;
        for (ServerLevel world : this.shadow$getAllLevels()) {
            int autoSaveInterval;
            boolean canSaveAtAll;
            SerializationBehavior serializationBehavior = ((PrimaryLevelDataBridge)world.getLevelData()).bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
            InheritableConfigHandle<WorldConfig> adapter = ((PrimaryLevelDataBridge)world.getLevelData()).bridge$configAdapter();
            boolean log = ((WorldConfig)adapter.get()).world.logAutoSave;
            if (!this.shadow$isRunning() || this.tickCount % 6000 == 0 || isForced) {
                ((PrimaryLevelDataBridge)world.getLevelData()).bridge$configAdapter().save();
            }
            if (!(canSaveAtAll = serializationBehavior != SerializationBehavior.NONE) || this.bridge$performAutosaveChecks() && !isForced && ((autoSaveInterval = ((WorldConfig)adapter.get()).world.autoSaveInterval) <= 0 || serializationBehavior != SerializationBehavior.AUTOMATIC || this.tickCount % autoSaveInterval != 0)) continue;
            if (log) {
                LOGGER.info("Saving chunks for level '{}'/{}", (Object)world, (Object)world.dimension().location());
            }
            world.save((ProgressListener)null, flush, world.noSave && !isForced);
            var0 = true;
        }
        if (isForced || this.tickCount % 6000 == 0) {
            GameProfileCache profileCache = this.shadow$getProfileCache();
            ((GameProfileCacheBridge)profileCache).bridge$setCanSave(true);
            profileCache.save();
            ((GameProfileCacheBridge)profileCache).bridge$setCanSave(false);
        }
        return var0;
    }

    @Overwrite
    public void setDifficulty(Difficulty difficulty, boolean forceDifficulty) {
        for (ServerLevel world : this.shadow$getAllLevels()) {
            this.bridge$setDifficulty(world, difficulty, forceDifficulty);
        }
    }

    @Override
    public void bridge$setDifficulty(ServerLevel world, Difficulty newDifficulty, boolean forceDifficulty) {
        PrimaryLevelDataBridge bridge;
        LevelData levelData;
        if (world.getLevelData().isDifficultyLocked() && !forceDifficulty) {
            return;
        }
        if (forceDifficulty && (levelData = world.getLevelData()) instanceof PrimaryLevelDataBridge && (bridge = (PrimaryLevelDataBridge)levelData).bridge$isVanilla()) {
            if (!bridge.bridge$customDifficulty()) {
                bridge.bridge$forceSetDifficulty(newDifficulty);
            }
        } else {
            ((PrimaryLevelData)world.getLevelData()).setDifficulty(newDifficulty);
        }
    }

    @Override
    public void bridge$initServices(Game game, Injector injector) {
        if (this.impl$serviceProvider == null) {
            this.impl$serviceProvider = new SpongeServerScopedServiceProvider(this, game, injector);
            this.impl$serviceProvider.init();
        }
    }

    @Override
    public SpongeServerScopedServiceProvider bridge$getServiceProvider() {
        return this.impl$serviceProvider;
    }

    @Inject(method={"reloadResources"}, at={@At(value="HEAD")})
    public void impl$reloadResources(Collection<String> datapacksToLoad, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        List<String> reloadablePacks = ((SpongeDataPackManager)this.dataPackManager()).registerPacks();
        datapacksToLoad.addAll(reloadablePacks);
        this.shadow$getPackRepository().reload();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Inject(method={"getChatDecorator"}, at={@At(value="RETURN")}, cancellable=true)
    private void impl$redirectChatDecorator(CallbackInfoReturnable<ChatDecorator> cir) {
        if (cir.getReturnValue() == ChatDecorator.PLAIN) {
            cir.setReturnValue((Object)this.impl$spongeDecorator);
        }
    }

    @Override
    public BlockableEventLoop<Runnable> bridge$spongeMainThreadExecutor() {
        return this.impl$spongeMainThreadExecutor;
    }

    @Inject(method={"pollTaskInternal"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$pollSpongeTasks(CallbackInfoReturnable<Boolean> cir) {
        if (this.impl$spongeMainThreadExecutor.pollTask()) {
            cir.setReturnValue((Object)true);
        }
    }
}

