/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.commands;

import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.commands.TeleportCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.ChangeEntityWorldEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.RotateEntityEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={TeleportCommand.class})
public abstract class TeleportCommandMixin {
    @Overwrite
    private static void performTeleport(CommandSourceStack source, net.minecraft.world.entity.Entity entityIn, ServerLevel worldIn, double x, double y, double z, Set<RelativeMovement> relativeList, float yaw, float pitch, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable TeleportCommand.LookAt facing) {
        double actualX = x;
        double actualY = y;
        double actualZ = z;
        double actualYaw = yaw;
        double actualPitch = pitch;
        if (!(entityIn instanceof ServerPlayer)) {
            actualYaw = Mth.wrapDegrees((float)yaw);
            actualPitch = Mth.wrapDegrees((float)pitch);
            actualPitch = Mth.clamp((double)actualPitch, (double)-90.0, (double)90.0);
        }
        if (worldIn == entityIn.level()) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.COMMAND);
                if (ShouldFire.MOVE_ENTITY_EVENT) {
                    MoveEntityEvent posEvent = SpongeEventFactory.createMoveEntityEvent(frame.currentCause(), (Entity)entityIn, VecHelper.toVector3d(entityIn.position()), new Vector3d(x, y, z), new Vector3d(x, y, z));
                    if (SpongeCommon.post(posEvent)) {
                        return;
                    }
                    actualX = posEvent.destinationPosition().x();
                    actualY = posEvent.destinationPosition().y();
                    actualZ = posEvent.destinationPosition().z();
                }
                if (ShouldFire.ROTATE_ENTITY_EVENT) {
                    RotateEntityEvent rotateEvent = SpongeEventFactory.createRotateEntityEvent(frame.currentCause(), (Entity)entityIn, new Vector3d(actualPitch, actualYaw, 0.0), new Vector3d(pitch, yaw, 0.0f));
                    SpongeCommon.post(rotateEvent);
                    actualYaw = rotateEvent.isCancelled() ? (double)entityIn.getYRot() : rotateEvent.toRotation().y();
                    double d = actualPitch = rotateEvent.isCancelled() ? (double)entityIn.getXRot() : rotateEvent.toRotation().x();
                }
                if (entityIn instanceof ServerPlayer) {
                    ChunkPos chunkpos = new ChunkPos(new BlockPos((int)actualX, (int)actualY, (int)actualZ));
                    worldIn.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkpos, 1, (Object)entityIn.getId());
                    entityIn.stopRiding();
                    if (((ServerPlayer)entityIn).isSleeping()) {
                        ((ServerPlayer)entityIn).stopSleepInBed(true, true);
                    }
                    ((ServerPlayer)entityIn).connection.teleport(actualX, actualY, actualZ, (float)actualYaw, (float)actualPitch, relativeList);
                } else {
                    entityIn.moveTo(actualX, actualY, actualZ, (float)actualYaw, (float)actualPitch);
                }
                entityIn.setYHeadRot((float)actualYaw);
            }
        }
        if (entityIn instanceof ServerPlayer) {
            PhaseTracker.getCauseStackManager().addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.COMMAND);
            ((ServerPlayer)entityIn).teleportTo(worldIn, x, y, z, yaw, pitch);
            PhaseTracker.getCauseStackManager().removeContext(EventContextKeys.MOVEMENT_TYPE);
        } else {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.COMMAND);
                ServerLevel fromWorld = (ServerLevel)entityIn.getCommandSenderWorld();
                ChangeEntityWorldEvent.Pre preEvent = PlatformHooks.INSTANCE.getEventHooks().callChangeEntityWorldEventPre(entityIn, worldIn);
                if (SpongeCommon.post(preEvent)) {
                    return;
                }
                ChangeEntityWorldEvent.Reposition posEvent = SpongeEventFactory.createChangeEntityWorldEventReposition(frame.currentCause(), (Entity)entityIn, (ServerWorld)entityIn.getCommandSenderWorld(), VecHelper.toVector3d(entityIn.position()), new Vector3d(x, y, z), preEvent.originalDestinationWorld(), new Vector3d(x, y, z), preEvent.destinationWorld());
                if (SpongeCommon.post(posEvent)) {
                    return;
                }
                entityIn.unRide();
                net.minecraft.world.entity.Entity result = entityIn.getType().create((Level)worldIn);
                if (result == null) {
                    return;
                }
                if (ShouldFire.ROTATE_ENTITY_EVENT) {
                    RotateEntityEvent rotateEvent = SpongeEventFactory.createRotateEntityEvent(frame.currentCause(), (Entity)entityIn, new Vector3d(entityIn.getXRot(), entityIn.getYRot(), 0.0f), new Vector3d(actualPitch, actualYaw, 0.0));
                    if (!SpongeCommon.post(rotateEvent)) {
                        actualYaw = Mth.wrapDegrees((double)rotateEvent.toRotation().y());
                        actualPitch = Mth.wrapDegrees((double)rotateEvent.toRotation().x());
                        actualPitch = Mth.clamp((double)actualPitch, (double)-90.0, (double)90.0);
                    } else {
                        actualYaw = entityIn.getYRot();
                        actualPitch = entityIn.getXRot();
                    }
                }
                result.restoreFrom(entityIn);
                result.moveTo(posEvent.destinationPosition().x(), posEvent.destinationPosition().y(), posEvent.destinationPosition().z(), (float)actualYaw, (float)actualPitch);
                result.setYHeadRot((float)actualYaw);
                worldIn.addDuringTeleport(result);
                entityIn.setRemoved(Entity.RemovalReason.CHANGED_DIMENSION);
                Sponge.eventManager().post(SpongeEventFactory.createChangeEntityWorldEventPost(PhaseTracker.getCauseStackManager().currentCause(), (Entity)result, (ServerWorld)fromWorld, preEvent.originalDestinationWorld(), preEvent.destinationWorld()));
            }
        }
        if (facing != null) {
            facing.perform(source, entityIn);
        }
        if (!(entityIn instanceof LivingEntity) || !((LivingEntity)entityIn).isFallFlying()) {
            entityIn.setDeltaMovement(entityIn.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            entityIn.setOnGround(true);
        }
        if (entityIn instanceof PathfinderMob) {
            ((PathfinderMob)entityIn).getNavigation().stop();
        }
    }
}

