/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.util.SortedArraySet;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.Ticket;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.accessor.server.level.TicketAccessor;
import org.spongepowered.common.bridge.world.DistanceManagerBridge;
import org.spongepowered.common.bridge.world.server.TicketBridge;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={DistanceManager.class})
public abstract class DistanceManagerMixin
implements DistanceManagerBridge {
    @Shadow
    @Final
    private Long2ObjectOpenHashMap<SortedArraySet<net.minecraft.server.level.Ticket<?>>> tickets;
    @Shadow
    private long ticketTickCounter;

    @Shadow
    private void shadow$addTicket(long chunkpos, net.minecraft.server.level.Ticket<?> ticket) {
    }

    @Shadow
    protected abstract void shadow$removeTicket(long var1, net.minecraft.server.level.Ticket<?> var3);

    @Override
    public boolean bridge$checkTicketValid(Ticket<?> ticket) {
        net.minecraft.server.level.Ticket nativeTicket = (net.minecraft.server.level.Ticket)ticket;
        SortedArraySet ticketsForChunk = (SortedArraySet)this.tickets.get(((TicketBridge)((Object)ticket)).bridge$chunkPosition());
        if (ticketsForChunk != null && ticketsForChunk.contains((Object)nativeTicket)) {
            return !((TicketAccessor)((Object)ticket)).invoker$timedOut(this.ticketTickCounter);
        }
        return false;
    }

    @Override
    public Ticks bridge$timeLeft(Ticket<?> ticket) {
        if (this.bridge$checkTicketValid(ticket)) {
            long ticksElapsed = this.ticketTickCounter - ((TicketAccessor)((Object)ticket)).accessor$createdTick();
            return new SpongeTicks(Math.max(0L, ((net.minecraft.server.level.Ticket)ticket).getType().timeout() - ticksElapsed));
        }
        return Ticks.zero();
    }

    @Override
    public boolean bridge$renewTicket(Ticket<?> ticket) {
        if (this.bridge$checkTicketValid(ticket)) {
            net.minecraft.server.level.Ticket nativeTicket = (net.minecraft.server.level.Ticket)ticket;
            ((TicketAccessor)((Object)ticket)).invoker$setCreatedTick(this.ticketTickCounter + nativeTicket.getType().timeout());
            return true;
        }
        return false;
    }

    @Override
    public <S, T> Optional<Ticket<T>> bridge$registerTicket(ServerWorld world, org.spongepowered.api.world.server.TicketType<T> ticketType, Vector3i pos, T value, int distanceLimit) {
        int distance = Mth.clamp((int)(34 - distanceLimit), (int)0, (int)33);
        TicketType type = (TicketType)ticketType;
        net.minecraft.server.level.Ticket<T> ticketToRequest = TicketAccessor.accessor$createInstance(type, distance, value);
        this.shadow$addTicket(VecHelper.toChunkPos(pos).toLong(), ticketToRequest);
        return Optional.of(((TicketBridge)ticketToRequest).bridge$retrieveAppropriateTicket());
    }

    @Override
    public boolean bridge$releaseTicket(Ticket<?> ticket) {
        if (this.bridge$checkTicketValid(ticket)) {
            this.shadow$removeTicket(((TicketBridge)((Object)ticket)).bridge$chunkPosition(), (net.minecraft.server.level.Ticket)ticket);
            return true;
        }
        return false;
    }

    @Override
    public <T> Collection<Ticket<T>> bridge$tickets(org.spongepowered.api.world.server.TicketType<T> ticketType) {
        return this.tickets.values().stream().flatMap(x -> x.stream().filter(ticket -> ticket.getType() == ticketType)).map(x -> (Ticket)x).collect(Collectors.toList());
    }

    @Inject(method={"addTicket(JLnet/minecraft/server/level/Ticket;)V"}, at={@At(value="HEAD")})
    private void impl$addChunkPosToTicket(long chunkPos, net.minecraft.server.level.Ticket<?> ticket, CallbackInfo ci) {
        ((TicketBridge)ticket).bridge$setChunkPosition(chunkPos);
    }

    @Redirect(method={"addTicket(JLnet/minecraft/server/level/Ticket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/Ticket;setCreatedTick(J)V"))
    private void impl$setParentTicketIfApplicable(net.minecraft.server.level.Ticket<?> storedTicket, long ticketTickCounter, long chunkPosAsLong, net.minecraft.server.level.Ticket<?> originalTicket) {
        if (storedTicket != originalTicket) {
            ((TicketBridge)originalTicket).bridge$setParentTicket(storedTicket);
        }
        ((TicketAccessor)storedTicket).invoker$setCreatedTick(ticketTickCounter);
    }
}

