/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.network.LegacyQueryHandler;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.network.status.SpongeLegacyMinecraftVersion;
import org.spongepowered.common.network.status.SpongeStatusResponse;
import org.spongepowered.common.util.NetworkUtil;

@Mixin(value={LegacyQueryHandler.class})
public abstract class LegacyQueryHandlerMixin
extends ChannelInboundHandlerAdapter {
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    @Final
    private ServerInfo server;
    private ByteBuf buf;

    @Shadow
    private static void shadow$sendFlushAndClose(ChannelHandlerContext ctx, ByteBuf data) {
    }

    @Shadow
    private static ByteBuf shadow$createLegacyDisconnectPacket(ByteBufAllocator $$0, String $$1) {
        throw new UnsupportedOperationException("Shadowed createLegacyDisconnectPacket");
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.buf = ctx.alloc().buffer();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.buf != null) {
            this.buf.release();
            this.buf = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf m = (ByteBuf)msg;
        this.buf.writeBytes(m);
        m.release();
        this.buf.markReaderIndex();
        boolean result = false;
        try {
            result = this.impl$readLegacy(ctx, this.buf);
        }
        finally {
            this.buf.resetReaderIndex();
            if (!result) {
                ByteBuf buf = this.buf;
                this.buf = null;
                ctx.pipeline().remove("legacy_query");
                ctx.fireChannelRead((Object)buf);
            }
        }
    }

    private boolean impl$readLegacy(ChannelHandlerContext ctx, ByteBuf buf) {
        if (buf.readUnsignedByte() != 254) {
            return false;
        }
        MinecraftServer server = (MinecraftServer)this.server;
        InetSocketAddress client = (InetSocketAddress)ctx.channel().remoteAddress();
        int i = buf.readableBytes();
        switch (i) {
            case 0: {
                LOGGER.debug("Ping: (<=1.3) from {}:{}", (Object)client.getAddress(), (Object)client.getPort());
                SpongeStatusResponse response = SpongeStatusResponse.postLegacy(server, client, SpongeLegacyMinecraftVersion.V1_3, null);
                if (response != null) {
                    this.writeResponse(ctx, String.format("%s\u00a7%d\u00a7%d", response.unformattedMotd(), response.onlinePlayers(), response.maxPlayers()));
                    break;
                }
                ctx.close();
                break;
            }
            case 1: {
                if (buf.readUnsignedByte() != 1) {
                    return false;
                }
                LOGGER.debug("Ping: (1.4-1.5) from {}:{}", (Object)client.getAddress(), (Object)client.getPort());
                SpongeStatusResponse response = SpongeStatusResponse.postLegacy(server, client, SpongeLegacyMinecraftVersion.V1_5, null);
                if (response != null) {
                    this.writeResponse(ctx, String.format("\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", response.version().protocolVersion(), response.version().name(), response.motd(), response.onlinePlayers(), response.maxPlayers()));
                    break;
                }
                ctx.close();
                break;
            }
            default: {
                short length;
                if (buf.readUnsignedByte() != 1 || buf.readUnsignedByte() != 250) {
                    return false;
                }
                if (!buf.isReadable(2) || !buf.isReadable((length = buf.readShort()) * 2)) break;
                if (!buf.readBytes(length * 2).toString(StandardCharsets.UTF_16BE).equals("MC|PingHost")) {
                    return false;
                }
                if (!buf.isReadable(2) || !buf.isReadable((int)(length = buf.readShort()))) break;
                short protocol = buf.readUnsignedByte();
                length = buf.readShort();
                String host = buf.readBytes(length * 2).toString(StandardCharsets.UTF_16BE);
                int port = buf.readInt();
                LOGGER.debug("Ping: (1.6) from {}:{}", (Object)client.getAddress(), (Object)client.getPort());
                SpongeStatusResponse response = SpongeStatusResponse.postLegacy(server, client, new SpongeLegacyMinecraftVersion(SpongeLegacyMinecraftVersion.V1_6, (int)protocol), InetSocketAddress.createUnresolved(NetworkUtil.cleanVirtualHost(host), port));
                if (response != null) {
                    this.writeResponse(ctx, String.format("\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", response.version().protocolVersion(), response.version().name(), response.motd(), response.onlinePlayers(), response.maxPlayers()));
                    break;
                }
                ctx.close();
            }
        }
        return true;
    }

    private void writeResponse(ChannelHandlerContext ctx, String response) {
        ByteBuf byteBuf = LegacyQueryHandlerMixin.shadow$createLegacyDisconnectPacket(ctx.alloc(), response);
        LegacyQueryHandlerMixin.shadow$sendFlushAndClose(ctx, byteBuf);
    }
}

