/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundResourcePackPopPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.bridge.network.protocol.game.ClientboundResourcePackPacketBridge;
import org.spongepowered.common.bridge.server.network.ServerCommonPacketListenerImplBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.profile.SpongeGameProfile;

@Mixin(value={ServerCommonPacketListenerImpl.class})
public abstract class ServerCommonPacketListenerImplMixin
implements ServerCommonPacketListenerImplBridge {
    @Shadow
    @Final
    protected Connection connection;
    @Shadow
    @Final
    protected MinecraftServer server;
    private Map<UUID, ResourcePackInfo> impl$resourcePackInfos = new ConcurrentHashMap<UUID, ResourcePackInfo>();
    private Map<UUID, ResourcePackCallback> impl$resourcePackCallbacks = new ConcurrentHashMap<UUID, ResourcePackCallback>();

    @Shadow
    public abstract void shadow$send(Packet<?> var1);

    @Shadow
    public abstract void shadow$disconnect(Component var1);

    @Shadow
    public void shadow$handleCustomPayload(ServerboundCustomPayloadPacket $$0) {
    }

    @Shadow
    protected abstract GameProfile shadow$playerProfile();

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;)V"}, at={@At(value="HEAD")})
    private void impl$onClientboundPacketSend(Packet<?> packet, PacketSendListener listener, CallbackInfo ci) {
        this.impl$modifyClientBoundPacket(packet);
    }

    public void impl$modifyClientBoundPacket(Packet<?> packet) {
        if (packet instanceof ClientboundResourcePackPushPacket) {
            ClientboundResourcePackPushPacket packPacket = (ClientboundResourcePackPushPacket)packet;
            this.impl$resourcePackInfos.put(packPacket.id(), ((ClientboundResourcePackPacketBridge)packPacket).bridge$getPackInfo());
        }
    }

    @Inject(method={"handleResourcePackResponse"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V", shift=At.Shift.AFTER)})
    private void impl$onHandleResourcePackResponse(ServerboundResourcePackPacket $$0, CallbackInfo ci) {
        net.minecraft.server.level.ServerPlayer player;
        @Nullable ResourcePackInfo pack = this.impl$resourcePackInfos.get($$0.id());
        if (pack == null) {
            return;
        }
        ServerCommonPacketListenerImplMixin serverCommonPacketListenerImplMixin = this;
        if (serverCommonPacketListenerImplMixin instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl gamePacketListener = (ServerGamePacketListenerImpl)serverCommonPacketListenerImplMixin;
            player = gamePacketListener.player;
        } else {
            player = null;
        }
        ResourcePackStatus status = switch ($$0.action()) {
            case ServerboundResourcePackPacket.Action.ACCEPTED -> ResourcePackStatus.ACCEPTED;
            case ServerboundResourcePackPacket.Action.DECLINED -> ResourcePackStatus.DECLINED;
            case ServerboundResourcePackPacket.Action.INVALID_URL -> ResourcePackStatus.INVALID_URL;
            case ServerboundResourcePackPacket.Action.FAILED_DOWNLOAD -> ResourcePackStatus.FAILED_DOWNLOAD;
            case ServerboundResourcePackPacket.Action.DOWNLOADED -> ResourcePackStatus.DOWNLOADED;
            case ServerboundResourcePackPacket.Action.FAILED_RELOAD -> ResourcePackStatus.FAILED_RELOAD;
            case ServerboundResourcePackPacket.Action.DISCARDED -> ResourcePackStatus.DISCARDED;
            case ServerboundResourcePackPacket.Action.SUCCESSFULLY_LOADED -> ResourcePackStatus.SUCCESSFULLY_LOADED;
            default -> throw new AssertionError();
        };
        @Nullable ResourcePackCallback callback = this.impl$resourcePackCallbacks.get($$0.id());
        if (callback != null && player != null) {
            callback.packEventReceived($$0.id(), status, (Audience)player);
        }
        if ($$0.action().isTerminal()) {
            this.impl$resourcePackInfos.remove($$0.id());
            this.impl$resourcePackCallbacks.remove($$0.id());
        }
        SpongeCommon.post(SpongeEventFactory.createResourcePackStatusEvent(PhaseTracker.getCauseStackManager().currentCause(), (ServerSideConnection)((Object)((ConnectionBridge)this.connection).bridge$getEngineConnection()), pack, Optional.ofNullable((ServerPlayer)player), SpongeGameProfile.of(this.shadow$playerProfile()), status));
    }

    @Override
    public void bridge$sendResourcePacks(@NonNull ResourcePackRequest request) {
        Objects.requireNonNull(request, "request");
        if (request.replace()) {
            this.bridge$clearResourcePacks();
        }
        Optional<Component> prompt = SpongeAdventure.asVanillaOpt(request.prompt());
        for (ResourcePackInfo pack : request.packs()) {
            ClientboundResourcePackPushPacket packet = new ClientboundResourcePackPushPacket(pack.id(), pack.uri().toASCIIString(), pack.hash(), request.required(), prompt);
            ((ClientboundResourcePackPacketBridge)packet).bridge$setPackInfo(pack);
            if (request.callback() != ResourcePackCallback.noOp()) {
                this.impl$resourcePackCallbacks.put(pack.id(), request.callback());
            }
            this.shadow$send((Packet<?>)packet);
        }
    }

    @Override
    public void bridge$removeResourcePacks(@NonNull UUID id, UUID ... others) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(id, "others");
        this.shadow$send((Packet<?>)new ClientboundResourcePackPopPacket(Optional.of(id)));
        for (UUID other : others) {
            this.shadow$send((Packet<?>)new ClientboundResourcePackPopPacket(Optional.of(other)));
        }
    }

    @Override
    public void bridge$clearResourcePacks() {
        this.shadow$send((Packet<?>)new ClientboundResourcePackPopPacket(Optional.empty()));
    }
}

