/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import com.mojang.authlib.GameProfile;
import io.netty.channel.Channel;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.configuration.ServerboundFinishConfigurationPacket;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.network.ConnectionAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.bridge.server.players.PlayerListBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.server.network.ServerCommonPacketListenerImplMixin;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.util.LocaleCache;

@Mixin(value={ServerConfigurationPacketListenerImpl.class})
public abstract class ServerConfigurationPacketListenerImplMixin
extends ServerCommonPacketListenerImplMixin {
    @Shadow
    @Final
    private GameProfile gameProfile;
    @Shadow
    @Final
    private Queue<ConfigurationTask> configurationTasks;
    @Shadow
    private @Nullable ConfigurationTask currentTask;
    private static final ConfigurationTask.Type impl$SPONGE_CONFIGURATION_TYPE = new ConfigurationTask.Type("sponge_configuration");
    private boolean impl$skipBanService;

    @Shadow
    public abstract void shadow$handleConfigurationFinished(ServerboundFinishConfigurationPacket var1);

    @Shadow
    protected abstract void shadow$finishCurrentTask(ConfigurationTask.Type var1);

    @Inject(method={"handleConfigurationFinished"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V")})
    private void impl$onHandleConfigurationFinished(ServerboundFinishConfigurationPacket $$0, CallbackInfo ci) {
        if (this.impl$skipBanService) {
            return;
        }
        ci.cancel();
        ((CompletableFuture)((CompletableFuture)((PlayerListBridge)this.server.getPlayerList()).bridge$canPlayerLogin(this.connection.getRemoteAddress(), this.gameProfile).handle((componentOpt, throwable) -> {
            if (throwable != null) {
                ((ConnectionBridge)this.connection).bridge$setKickReason((Component)Component.literal((String)"An error occurred checking ban/whitelist status."));
                SpongeCommon.logger().error("An error occurred when checking the ban/whitelist status of {}.", (Object)this.gameProfile.getId().toString());
                SpongeCommon.logger().error(throwable);
            } else if (componentOpt != null) {
                ((ConnectionBridge)this.connection).bridge$setKickReason((Component)componentOpt);
            }
            try {
                ((SpongeServer)SpongeCommon.server()).userManager().handlePlayerLogin(this.gameProfile);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
            return null;
        })).handleAsync((ignored, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    throw (CompletionException)throwable;
                }
                throw new CompletionException((Throwable)throwable);
            }
            try {
                this.impl$skipBanService = true;
                this.shadow$handleConfigurationFinished($$0);
                ((SpongeServer)SpongeCommon.server()).userManager().removeFromCache(this.gameProfile.getId());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.impl$skipBanService = false;
            }
            return null;
        }, (Executor)SpongeCommon.server())).exceptionally(throwable -> {
            SpongeCommon.logger().error("Forcibly disconnecting user {}({}) due to an error during login.", (Object)this.gameProfile.getName(), (Object)this.gameProfile.getId(), throwable);
            this.shadow$disconnect((Component)Component.literal((String)"Internal Server Error: unable to complete login."));
            return null;
        });
    }

    @Redirect(method={"handleConfigurationFinished"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;"))
    private Component impl$onCanPlayerLogin(PlayerList instance, SocketAddress $$0, GameProfile $$1) {
        return null;
    }

    @Inject(method={"addOptionalTasks"}, at={@At(value="TAIL")})
    private void impl$callConfigurationEvent(CallbackInfo ci) {
        this.configurationTasks.add(new ConfigurationTask(){

            public void start(Consumer<Packet<?>> var1) {
                ServerSideConnection connection = (ServerSideConnection)((Object)((ConnectionBridge)ServerConfigurationPacketListenerImplMixin.this.connection).bridge$getEngineConnection());
                ServerSideConnectionEvent.Configuration event = SpongeEventFactory.createServerSideConnectionEventConfiguration(PhaseTracker.getCauseStackManager().currentCause(), connection, SpongeGameProfile.of(ServerConfigurationPacketListenerImplMixin.this.gameProfile));
                SpongeCommon.post(event);
                TransactionStore store = ConnectionUtil.getTransactionStore(connection);
                if (store.isEmpty()) {
                    ServerConfigurationPacketListenerImplMixin.this.shadow$finishCurrentTask(impl$SPONGE_CONFIGURATION_TYPE);
                }
            }

            public ConfigurationTask.Type type() {
                return impl$SPONGE_CONFIGURATION_TYPE;
            }
        });
    }

    @Override
    public void shadow$handleCustomPayload(ServerboundCustomPayloadPacket $$0) {
        super.shadow$handleCustomPayload($$0);
        if (this.currentTask == null || this.currentTask.type() != impl$SPONGE_CONFIGURATION_TYPE) {
            return;
        }
        ServerSideConnection connection = (ServerSideConnection)((Object)((ConnectionBridge)this.connection).bridge$getEngineConnection());
        TransactionStore store = ConnectionUtil.getTransactionStore(connection);
        if (store.isEmpty()) {
            this.shadow$finishCurrentTask(impl$SPONGE_CONFIGURATION_TYPE);
        }
    }

    @Inject(method={"handleConfigurationFinished"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;getPlayerForLogin(Lcom/mojang/authlib/GameProfile;Lnet/minecraft/server/level/ClientInformation;)Lnet/minecraft/server/level/ServerPlayer;")})
    private void impl$sendChannels(CallbackInfo ci) {
        ((SpongeChannelManager)SpongeCommon.game().channelManager()).sendChannelRegistrations(((ConnectionBridge)this.connection).bridge$getEngineConnection());
    }

    @Inject(method={"handleClientInformation"}, at={@At(value="TAIL")})
    private void impl$onHandleClientInformation(ServerboundClientInformationPacket packet, CallbackInfo ci) {
        Channel channel = ((ConnectionAccessor)this.connection).accessor$channel();
        channel.attr(SpongeAdventure.CHANNEL_LOCALE).set((Object)LocaleCache.getLocale(packet.information().language()));
    }
}

