/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.kyori.adventure.text.Component;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.login.ServerboundKeyPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.bridge.network.ServerLoginPacketListenerImplBridge;
import org.spongepowered.common.bridge.server.players.PlayerListBridge;
import org.spongepowered.common.network.SpongeEngineConnection;
import org.spongepowered.common.profile.SpongeGameProfile;

@Mixin(value={ServerLoginPacketListenerImpl.class})
public abstract class ServerLoginPacketListenerImplMixin
implements ServerLoginPacketListenerImplBridge {
    @Shadow
    @Final
    static Logger LOGGER;
    @Shadow
    @Final
    Connection connection;
    @Shadow
    private GameProfile authenticatedProfile;
    @Shadow
    @Final
    MinecraftServer server;
    @Shadow
    private ServerLoginPacketListenerImpl.State state;
    @Shadow
    @Final
    private byte[] challenge;
    @Shadow
    @Nullable String requestedUsername;
    private static final ExecutorService impl$EXECUTOR;

    @Shadow
    public abstract void shadow$disconnect(net.minecraft.network.chat.Component var1);

    @Shadow
    abstract void shadow$startClientVerification(GameProfile var1);

    @Override
    public Connection bridge$getConnection() {
        return this.connection;
    }

    @Redirect(method={"verifyLoginAndFinishConnectionSetup"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;"))
    private net.minecraft.network.chat.Component impl$onCanPlayerLogin(PlayerList instance, SocketAddress $$0, GameProfile $$1) {
        return null;
    }

    private void impl$disconnectClient(Component disconnectMessage) {
        net.minecraft.network.chat.Component reason = SpongeAdventure.asVanilla(disconnectMessage);
        this.shadow$disconnect(reason);
    }

    @Inject(method={"startClientVerification(Lcom/mojang/authlib/GameProfile;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/server/network/ServerLoginPacketListenerImpl;state:Lnet/minecraft/server/network/ServerLoginPacketListenerImpl$State;")}, cancellable=true)
    private void impl$handleAuthEventCancellation(CallbackInfo ci) {
        ci.cancel();
        ((CompletableFuture)((CompletableFuture)((PlayerListBridge)this.server.getPlayerList()).bridge$canPlayerLogin(this.connection.getRemoteAddress(), this.authenticatedProfile).handle((componentOpt, throwable) -> {
            if (throwable != null) {
                ((ConnectionBridge)this.connection).bridge$setKickReason((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)"An error occurred checking ban/whitelist status."));
                SpongeCommon.logger().error("An error occurred when checking the ban/whitelist status of {}.", (Object)this.authenticatedProfile.getId().toString());
                SpongeCommon.logger().error(throwable);
            } else if (componentOpt != null) {
                ((ConnectionBridge)this.connection).bridge$setKickReason((net.minecraft.network.chat.Component)componentOpt);
            }
            return null;
        })).handleAsync((ignored, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    throw (CompletionException)throwable;
                }
                throw new CompletionException((Throwable)throwable);
            }
            this.impl$fireAuthEvent();
            return null;
        }, (Executor)this.bridge$getExecutor())).exceptionally(throwable -> {
            SpongeCommon.logger().error("Forcibly disconnecting user {}({}) due to an error during login.", (Object)this.authenticatedProfile.getName(), (Object)this.authenticatedProfile.getId(), throwable);
            this.shadow$disconnect((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)"Internal Server Error: unable to complete login."));
            return null;
        });
    }

    @Override
    public ExecutorService bridge$getExecutor() {
        return impl$EXECUTOR;
    }

    private void impl$fireAuthEvent() {
        @Nullable net.minecraft.network.chat.Component kickReason = ((ConnectionBridge)this.connection).bridge$getKickReason();
        Object disconnectMessage = kickReason != null ? SpongeAdventure.asAdventure(kickReason) : Component.text((String)"You are not allowed to log in to this server.");
        SpongeEngineConnection connection = ((ConnectionBridge)this.connection).bridge$getEngineConnection();
        connection.setGameProfile(this.authenticatedProfile);
        Cause cause = Cause.of(EventContext.empty(), this);
        ServerSideConnectionEvent.Auth event = SpongeEventFactory.createServerSideConnectionEventAuth(cause, disconnectMessage, disconnectMessage, (ServerSideConnection)((Object)connection), SpongeGameProfile.of(this.authenticatedProfile));
        if (connection.postGuardedEvent(event)) {
            this.impl$disconnectClient(event.message());
            return;
        }
        this.state = ServerLoginPacketListenerImpl.State.NEGOTIATING;
    }

    @Overwrite
    public void handleKey(ServerboundKeyPacket packet) {
        String $$5;
        Validate.validState((this.state == ServerLoginPacketListenerImpl.State.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey $$1 = this.server.getKeyPair().getPrivate();
            if (!packet.isChallengeValid(this.challenge, $$1)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey $$2 = packet.getSecretKey($$1);
            Cipher $$3 = Crypt.getCipher((int)2, (Key)$$2);
            Cipher $$4 = Crypt.getCipher((int)1, (Key)$$2);
            $$5 = new BigInteger(Crypt.digestData((String)"", (PublicKey)this.server.getKeyPair().getPublic(), (SecretKey)$$2)).toString(16);
            this.state = ServerLoginPacketListenerImpl.State.AUTHENTICATING;
            this.connection.setEncryptionKey($$3, $$4);
        }
        catch (CryptException var7) {
            throw new IllegalStateException("Protocol error", var7);
        }
        this.bridge$getExecutor().submit(() -> {
            String username = Objects.requireNonNull(this.requestedUsername, "Player name not initialized");
            try {
                ProfileResult $$1 = this.server.getSessionService().hasJoinedServer(username, $$5, this.impl$getAddress());
                if ($$1 != null) {
                    GameProfile $$2 = $$1.profile();
                    LOGGER.info("UUID of player {} is {}", (Object)$$2.getName(), (Object)$$2.getId());
                    this.shadow$startClientVerification($$2);
                } else if (this.server.isSingleplayer()) {
                    LOGGER.warn("Failed to verify username but will let them in anyway!");
                    this.shadow$startClientVerification(UUIDUtil.createOfflineProfile((String)username));
                } else {
                    this.shadow$disconnect((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"multiplayer.disconnect.unverified_username"));
                    LOGGER.error("Username '{}' tried to join with an invalid session", (Object)username);
                }
            }
            catch (AuthenticationUnavailableException var4) {
                if (this.server.isSingleplayer()) {
                    LOGGER.warn("Authentication servers are down but will let them in anyway!");
                    this.shadow$startClientVerification(UUIDUtil.createOfflineProfile((String)username));
                }
                this.shadow$disconnect((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"multiplayer.disconnect.authservers_down"));
                LOGGER.error("Couldn't verify username because servers are unavailable");
            }
        });
    }

    private @Nullable InetAddress impl$getAddress() {
        SocketAddress $$0 = this.connection.getRemoteAddress();
        return this.server.getPreventProxyConnections() && $$0 instanceof InetSocketAddress ? ((InetSocketAddress)$$0).getAddress() : null;
    }

    static {
        impl$EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("Sponge-LoginThread-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    }
}

