/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.damagesource;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import org.spongepowered.api.Sponge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.accessor.world.level.ExplosionAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;

@Mixin(value={DamageSources.class})
public abstract class DamageSourcesMixin {
    @Redirect(method={"explosion(Lnet/minecraft/world/level/Explosion;)Lnet/minecraft/world/damagesource/DamageSource;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Explosion;getIndirectSourceEntity()Lnet/minecraft/world/entity/LivingEntity;"))
    private LivingEntity onSetExplosionSource(Explosion explosion) {
        Entity entity;
        if (explosion.getIndirectSourceEntity() == null && (entity = explosion.getDirectSourceEntity()) instanceof CreatorTrackedBridge) {
            Optional indirectSource;
            CreatorTrackedBridge creatorBridge = (CreatorTrackedBridge)entity;
            if (!((LevelBridge)((ExplosionAccessor)explosion).accessor$level()).bridge$isFake() && (indirectSource = creatorBridge.tracker$getCreatorUUID().flatMap(x -> Sponge.server().player((UUID)x))).isPresent()) {
                return (LivingEntity)indirectSource.get();
            }
        }
        return explosion.getIndirectSourceEntity();
    }
}

