/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.FallingBlock;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.SleepingEvent;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.item.inventory.UseItemStackEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.world.entity.LivingEntityBridge;
import org.spongepowered.common.bridge.world.entity.PlatformLivingEntityBridge;
import org.spongepowered.common.bridge.world.entity.player.PlayerBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.entity.living.human.HumanEntity;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.cause.entity.damage.SpongeDamageSources;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;
import org.spongepowered.common.util.DamageEventUtil;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends EntityMixin
implements LivingEntityBridge,
PlatformLivingEntityBridge {
    @Shadow
    protected int useItemRemaining;
    @Shadow
    protected boolean dead;
    @Shadow
    protected int deathScore;
    @Shadow
    protected ItemStack useItem;
    @Shadow
    private @Nullable DamageSource lastDamageSource;
    @Shadow
    private long lastDamageStamp;
    private @Nullable ItemStack impl$activeItemStackCopy;
    private @Nullable Vector3d impl$preTeleportPosition;
    private int impl$deathEventsPosted;

    @Shadow
    public abstract AttributeInstance shadow$getAttribute(Holder<Attribute> var1);

    @Shadow
    public abstract void shadow$setHealth(float var1);

    @Shadow
    public abstract void shadow$setAbsorptionAmount(float var1);

    @Shadow
    public abstract void shadow$setItemInHand(InteractionHand var1, @Nullable ItemStack var2);

    @Shadow
    public abstract void shadow$stopUsingItem();

    @Shadow
    public abstract int shadow$getUseItemRemainingTicks();

    @Shadow
    public abstract float shadow$getAbsorptionAmount();

    @Shadow
    public abstract float shadow$getHealth();

    @Shadow
    public abstract boolean shadow$hasEffect(Holder<MobEffect> var1);

    @Shadow
    public abstract ItemStack shadow$getItemBySlot(EquipmentSlot var1);

    @Shadow
    public abstract ItemStack shadow$getMainHandItem();

    @Shadow
    public abstract CombatTracker shadow$getCombatTracker();

    @Shadow
    public void shadow$kill() {
    }

    @Shadow
    public abstract InteractionHand shadow$getUsedItemHand();

    @Shadow
    protected abstract void shadow$hurtCurrentlyUsedShield(float var1);

    @Shadow
    protected abstract void shadow$blockUsingShield(LivingEntity var1);

    @Shadow
    public abstract Optional<BlockPos> shadow$getSleepingPos();

    @Shadow
    protected abstract void shadow$spawnItemParticles(ItemStack var1, int var2);

    @Shadow
    public abstract boolean shadow$onClimbable();

    @Shadow
    public abstract void shadow$setSprinting(boolean var1);

    @Shadow
    public abstract void shadow$setLastHurtMob(net.minecraft.world.entity.Entity var1);

    @Shadow
    protected abstract void shadow$hurtArmor(DamageSource var1, float var2);

    @Shadow
    public abstract ItemStack shadow$getItemInHand(InteractionHand var1);

    @Shadow
    protected abstract void shadow$dropEquipment();

    @Shadow
    protected abstract void shadow$dropAllDeathLoot(DamageSource var1);

    @Shadow
    public abstract @Nullable LivingEntity shadow$getKillCredit();

    @Shadow
    protected abstract void shadow$createWitherRose(@Nullable LivingEntity var1);

    @Shadow
    public abstract Collection<MobEffectInstance> shadow$getActiveEffects();

    @Shadow
    public abstract float shadow$getMaxHealth();

    @Shadow
    public abstract AttributeMap shadow$getAttributes();

    @Shadow
    public abstract void shadow$clearSleepingPos();

    @Shadow
    protected abstract float shadow$getDamageAfterArmorAbsorb(DamageSource var1, float var2);

    @Shadow
    protected abstract float shadow$getDamageAfterMagicAbsorb(DamageSource var1, float var2);

    @Shadow
    public abstract void shadow$stopRiding();

    @Override
    public boolean bridge$damageEntity(DamageSource damageSource, float damage) {
        if (this.shadow$isInvulnerableTo(damageSource)) {
            return false;
        }
        boolean isHuman = (LivingEntity)this instanceof Player;
        float originalDamage = damage = this.bridge$applyModDamage((LivingEntity)this, damageSource, damage);
        if (damage <= 0.0f) {
            return false;
        }
        ArrayList<DamageFunction> originalFunctions = new ArrayList<DamageFunction>();
        Optional<DamageFunction> hardHatFunction = DamageEventUtil.createHardHatModifier((LivingEntity)this, damageSource);
        Optional<DamageFunction> armorFunction = DamageEventUtil.createArmorModifiers((LivingEntity)this, damageSource);
        Optional<DamageFunction> resistanceFunction = DamageEventUtil.createResistanceModifier((LivingEntity)this, damageSource);
        Optional<List<DamageFunction>> armorEnchantments = DamageEventUtil.createEnchantmentModifiers((LivingEntity)this, damageSource);
        Optional<DamageFunction> absorptionFunction = DamageEventUtil.createAbsorptionModifier((LivingEntity)this);
        Optional<DamageFunction> shieldFunction = DamageEventUtil.createShieldFunction((LivingEntity)this, damageSource, damage);
        hardHatFunction.ifPresent(originalFunctions::add);
        shieldFunction.ifPresent(originalFunctions::add);
        armorFunction.ifPresent(originalFunctions::add);
        resistanceFunction.ifPresent(originalFunctions::add);
        armorEnchantments.ifPresent(originalFunctions::addAll);
        absorptionFunction.ifPresent(originalFunctions::add);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            float f2;
            DamageEventUtil.generateCauseFor(damageSource, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.currentCause(), (Entity)((Object)this), originalFunctions, originalDamage);
            if (damageSource != SpongeDamageSources.IGNORED) {
                SpongeCommon.post(event);
            }
            if (event.isCancelled()) {
                boolean bl = false;
                return bl;
            }
            damage = (float)event.finalDamage();
            damage = this.bridge$applyModDamageBeforeFunctions((LivingEntity)this, damageSource, damage);
            ItemStack helmet = this.shadow$getItemBySlot(EquipmentSlot.HEAD);
            if ((damageSource.getDirectEntity() instanceof FallingBlock || damageSource.is(DamageTypeTags.DAMAGES_HELMET)) && !helmet.isEmpty()) {
                helmet.hurtAndBreak((int)(event.baseDamage() * 4.0 + (double)this.random.nextFloat() * event.baseDamage() * 2.0), (LivingEntity)this, EquipmentSlot.HEAD);
            }
            boolean hurtStack = false;
            if (shieldFunction.isPresent()) {
                net.minecraft.world.entity.Entity entity;
                this.shadow$hurtCurrentlyUsedShield((float)event.baseDamage());
                hurtStack = true;
                if (!damageSource.is(DamageTypeTags.IS_PROJECTILE) && (entity = damageSource.getDirectEntity()) instanceof LivingEntity) {
                    this.shadow$blockUsingShield((LivingEntity)entity);
                }
            }
            if (!damageSource.is(DamageTypeTags.BYPASSES_ARMOR) && armorFunction.isPresent()) {
                this.shadow$hurtArmor(damageSource, (float)event.baseDamage());
                hurtStack = true;
            }
            if (hurtStack && isHuman) {
                PhaseTracker.SERVER.getPhaseContext().getTransactor().logPlayerInventoryChange((Player)this, PlayerInventoryTransaction.EventCreator.STANDARD);
                ((Player)this).inventoryMenu.broadcastChanges();
            }
            if (resistanceFunction.isPresent() && (f2 = (float)event.damage(resistanceFunction.get().modifier()) - damage) > 0.0f && f2 < 3.4028235E37f) {
                if ((LivingEntity)this instanceof net.minecraft.server.level.ServerPlayer) {
                    ((net.minecraft.server.level.ServerPlayer)((LivingEntity)this)).awardStat(Stats.DAMAGE_RESISTED, Math.round(f2 * 10.0f));
                } else if (damageSource.getEntity() instanceof net.minecraft.server.level.ServerPlayer) {
                    ((net.minecraft.server.level.ServerPlayer)damageSource.getEntity()).awardStat(Stats.DAMAGE_DEALT_RESISTED, Math.round(f2 * 10.0f));
                }
            }
            double absorptionModifier = absorptionFunction.map(function -> event.damage(function.modifier())).orElse(0.0);
            if (absorptionFunction.isPresent()) {
                absorptionModifier = event.damage(absorptionFunction.get().modifier());
            }
            float f = (float)event.finalDamage() - (float)absorptionModifier;
            this.shadow$setAbsorptionAmount(Math.max(this.shadow$getAbsorptionAmount() + (float)absorptionModifier, 0.0f));
            if (f > 0.0f && f < 3.4028235E37f && (LivingEntity)this instanceof net.minecraft.server.level.ServerPlayer) {
                ((Player)this).awardStat(Stats.DAMAGE_DEALT_ABSORBED, Math.round(f * 10.0f));
            }
            if (damage != 0.0f) {
                if (isHuman) {
                    ((Player)this).causeFoodExhaustion(damageSource.getFoodExhaustion());
                }
                float f22 = this.shadow$getHealth();
                this.shadow$setHealth(f22 - damage);
                this.shadow$getCombatTracker().recordDamage(damageSource, damage);
                if (isHuman) {
                    if (damage < 3.4028235E37f) {
                        ((Player)this).awardStat(Stats.DAMAGE_TAKEN, Math.round(damage * 10.0f));
                    }
                    boolean bl = true;
                    return bl;
                }
                this.shadow$setAbsorptionAmount(this.shadow$getAbsorptionAmount() - damage);
            }
            boolean bl = true;
            return bl;
        }
    }

    @Inject(method={"setHealth"}, at={@At(value="HEAD")})
    private void impl$resetDeathEventCounter(float health, CallbackInfo info) {
        if (this.shadow$getHealth() <= 0.0f && health > 0.0f) {
            this.impl$deathEventsPosted = 0;
        }
    }

    @Redirect(method={"dropExperience()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getExperienceReward()I"))
    protected int impl$exposeGetExperienceForDeath(LivingEntity entity) {
        return this.bridge$getExperiencePointsOnDeath(entity);
    }

    @Overwrite
    protected void actuallyHurt(DamageSource damageSource, float damage) {
        this.bridge$damageEntity(damageSource, damage);
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$throwDestructEntityDeath(DamageSource cause, CallbackInfo ci) {
        boolean throwEvent;
        boolean bl = throwEvent = !((LevelBridge)this.shadow$level()).bridge$isFake() && Sponge.isServerAvailable() && Sponge.server().onMainThread();
        if (!this.dead) {
            if (throwEvent && this.impl$deathEventsPosted <= 3) {
                ++this.impl$deathEventsPosted;
                if (SpongeCommonEventFactory.callDestructEntityEventDeath((LivingEntity)this, cause).isCancelled()) {
                    ci.cancel();
                }
            }
        } else {
            this.impl$deathEventsPosted = 0;
        }
    }

    @Inject(method={"die"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;broadcastEntityEvent(Lnet/minecraft/world/entity/Entity;B)V")}, cancellable=true)
    private void impl$doNotSendStateForHumans(DamageSource cause, CallbackInfo ci) {
        if ((LivingEntity)this instanceof HumanEntity) {
            ci.cancel();
        }
    }

    @Redirect(method={"dropAllDeathLoot"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;dropEquipment()V"))
    private void tracker$dropInventory(LivingEntity thisEntity) {
        if (thisEntity instanceof PlayerBridge && ((PlayerBridge)thisEntity).bridge$keepInventory()) {
            return;
        }
        this.shadow$dropEquipment();
    }

    @Inject(method={"pushEntities"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$pushEntitiesIfNotVanished(CallbackInfo ci) {
        if (this.bridge$vanishState().ignoresCollisions()) {
            ci.cancel();
        }
    }

    @Redirect(method={"triggerItemUseEffects"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;spawnItemParticles(Lnet/minecraft/world/item/ItemStack;I)V"))
    private void impl$hideItemParticlesIfVanished(LivingEntity livingEntity, ItemStack stack, int count) {
        if (this.bridge$vanishState().createsParticles()) {
            this.shadow$spawnItemParticles(stack, count);
        }
    }

    @Inject(method={"randomTeleport"}, at={@At(value="HEAD")})
    private void impl$snapshotPositionBeforeVanillaTeleportLogic(double x, double y, double z, boolean changeState, CallbackInfoReturnable<Boolean> cir) {
        this.impl$preTeleportPosition = new Vector3d(this.shadow$getX(), this.shadow$getY(), this.shadow$getZ());
    }

    @Inject(method={"randomTeleport"}, at={@At(value="RETURN", ordinal=0, shift=At.Shift.BY, by=2)}, cancellable=true)
    private void impl$callMoveEntityEventForTeleport(double x, double y, double z, boolean changeState, CallbackInfoReturnable<Boolean> cir) {
        if (!ShouldFire.MOVE_ENTITY_EVENT) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            MoveEntityEvent event;
            frame.pushCause(this);
            if (!frame.currentContext().containsKey(EventContextKeys.MOVEMENT_TYPE)) {
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.ENTITY_TELEPORT);
            }
            if (SpongeCommon.post(event = SpongeEventFactory.createMoveEntityEvent(frame.currentCause(), (Entity)((Object)this), this.impl$preTeleportPosition, new Vector3d(this.shadow$getX(), this.shadow$getY(), this.shadow$getZ()), new Vector3d(x, y, z)))) {
                this.shadow$teleportTo(this.impl$preTeleportPosition.x(), this.impl$preTeleportPosition.y(), this.impl$preTeleportPosition.z());
                cir.setReturnValue((Object)false);
                return;
            }
            this.shadow$teleportTo(event.destinationPosition().x(), event.destinationPosition().y(), event.destinationPosition().z());
        }
    }

    @Inject(method={"isPickable"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$ifVanishedDoNotPick(CallbackInfoReturnable<Boolean> cir) {
        if (this.bridge$vanishState().ignoresCollisions()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V"))
    private void impl$ignoreExperienceLevelSoundsWhileVanished(Level world, Player player, double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch) {
        if (!this.bridge$vanishState().createsSounds()) {
            return;
        }
        world.playSound(player, x, y, z, sound, category, volume, pitch);
    }

    @Redirect(method={"checkFallDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;sendParticles(Lnet/minecraft/core/particles/ParticleOptions;DDDIDDDD)I"))
    private <T extends ParticleOptions> int impl$vanishSpawnParticleForFallState(ServerLevel serverLevel, T options, double xCoord, double yCoord, double zCoord, int numberOfParticles, double xOffset, double yOffset, double zOffset, double particleSpeed) {
        if (this.bridge$vanishState().createsParticles()) {
            return serverLevel.sendParticles(options, xCoord, yCoord, zCoord, numberOfParticles, xOffset, yOffset, zOffset, particleSpeed);
        }
        return 0;
    }

    @Inject(method={"broadcastBreakEvent(Lnet/minecraft/world/entity/EquipmentSlot;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$vanishDoesNotBroadcastBreakEvents(EquipmentSlot slot, CallbackInfo ci) {
        if (this.bridge$vanishState().invisible()) {
            ci.cancel();
        }
    }

    @Inject(method={"updatingUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;stopUsingItem()V")})
    protected void impl$updateHealthForUseFinish(CallbackInfo ci) {
    }

    @Inject(method={"startUsingItem"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;useItem:Lnet/minecraft/world/item/ItemStack;")})
    private void impl$onSetActiveItemStack(InteractionHand hand, CallbackInfo ci, ItemStack stack) {
        UseItemStackEvent.Start event;
        if (this.shadow$level().isClientSide) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
            HandType handType = (HandType)hand;
            this.impl$addSelfToFrame(frame, snapshot, handType);
            Ticks useDuration = SpongeTicks.ticksOrInfinite(stack.getUseDuration());
            event = SpongeEventFactory.createUseItemStackEventStart(PhaseTracker.getCauseStackManager().currentCause(), useDuration, useDuration, snapshot);
        }
        if (SpongeCommon.post(event)) {
            ci.cancel();
        } else {
            this.useItemRemaining = SpongeTicks.toSaturatedIntOrInfinite(event.remainingDuration());
        }
    }

    @Redirect(method={"startUsingItem"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;useItemRemaining:I"))
    private void impl$getItemDuration(LivingEntity this$0, int count) {
        if (this.shadow$level().isClientSide) {
            this.useItemRemaining = count;
        }
    }

    private void impl$addSelfToFrame(CauseStackManager.StackFrame frame, ItemStackSnapshot snapshot, HandType hand) {
        frame.addContext(EventContextKeys.USED_HAND, hand);
        this.impl$addSelfToFrame(frame, snapshot);
    }

    private void impl$addSelfToFrame(CauseStackManager.StackFrame frame, ItemStackSnapshot snapshot) {
        frame.pushCause(this);
        frame.addContext(EventContextKeys.USED_ITEM, snapshot);
        if (this instanceof ServerPlayer) {
            frame.addContext(EventContextKeys.CREATOR, ((ServerPlayer)((Object)this)).uniqueId());
            frame.addContext(EventContextKeys.NOTIFIER, ((ServerPlayer)((Object)this)).uniqueId());
        }
    }

    @Redirect(method={"updateUsingItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getUseItemRemainingTicks()I", ordinal=0))
    private int impl$onGetRemainingItemDuration(LivingEntity self) {
        UseItemStackEvent.Tick event;
        if (this.shadow$level().isClientSide) {
            return self.getUseItemRemainingTicks();
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(this.useItem);
            HandType handType = (HandType)this.shadow$getUsedItemHand();
            this.impl$addSelfToFrame(frame, snapshot, handType);
            Ticks useItemRemainingTicks = SpongeTicks.ticksOrInfinite(this.useItemRemaining);
            event = SpongeEventFactory.createUseItemStackEventTick(PhaseTracker.getCauseStackManager().currentCause(), useItemRemainingTicks, useItemRemainingTicks, snapshot);
            SpongeCommon.post(event);
        }
        int n = this.useItemRemaining = event.remainingDuration().isInfinite() ? -1 : Math.max(SpongeTicks.toSaturatedIntOrInfinite(event.remainingDuration()), 1);
        if (event.isCancelled()) {
            return 26;
        }
        return this.shadow$getUseItemRemainingTicks();
    }

    @Inject(method={"updateUsingItem"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;useItemRemaining:I", opcode=181)}, cancellable=true)
    private void impl$dontReduceInfiniteRemainingItemDuration(CallbackInfo ci) {
        if (this.useItemRemaining == -1) {
            ci.cancel();
        }
    }

    @Inject(method={"completeUsingItem"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;triggerItemUseEffects(Lnet/minecraft/world/item/ItemStack;I)V")})
    private void impl$onUpdateItemUse(CallbackInfo ci) {
        UseItemStackEvent.Finish event;
        if (this.shadow$level().isClientSide) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(this.useItem);
            HandType handType = (HandType)this.shadow$getUsedItemHand();
            this.impl$addSelfToFrame(frame, snapshot, handType);
            Ticks useItemRemainingTicks = SpongeTicks.ticksOrInfinite(this.useItemRemaining);
            event = SpongeEventFactory.createUseItemStackEventFinish(PhaseTracker.getCauseStackManager().currentCause(), useItemRemainingTicks, useItemRemainingTicks, snapshot);
        }
        SpongeCommon.post(event);
        if (event.remainingDuration().isInfinite() || event.remainingDuration().ticks() > 0L) {
            this.useItemRemaining = SpongeTicks.toSaturatedIntOrInfinite(event.remainingDuration());
            ci.cancel();
        } else if (event.isCancelled()) {
            this.shadow$stopUsingItem();
            ci.cancel();
        } else {
            this.impl$activeItemStackCopy = this.useItem.copy();
        }
    }

    @Redirect(method={"completeUsingItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setItemInHand(Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/item/ItemStack;)V"))
    private void impl$onSetHeldItem(LivingEntity self, InteractionHand hand, ItemStack stack) {
        UseItemStackEvent.Replace event;
        if (this.shadow$level().isClientSide) {
            self.setItemInHand(hand, stack);
            return;
        }
        ItemStackSnapshot activeItemStackSnapshot = ItemStackUtil.snapshotOf(this.impl$activeItemStackCopy == null ? ItemStack.EMPTY : this.impl$activeItemStackCopy);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack == null ? ItemStack.EMPTY : stack);
            HandType handType = (HandType)hand;
            this.impl$addSelfToFrame(frame, activeItemStackSnapshot, handType);
            Ticks useItemRemainingTicks = SpongeTicks.ticksOrInfinite(this.useItemRemaining);
            event = SpongeEventFactory.createUseItemStackEventReplace(PhaseTracker.getCauseStackManager().currentCause(), useItemRemainingTicks, useItemRemainingTicks, activeItemStackSnapshot, new Transaction<ItemStackSnapshot>(ItemStackUtil.snapshotOf(this.impl$activeItemStackCopy), snapshot));
        }
        if (SpongeCommon.post(event)) {
            this.shadow$setItemInHand(hand, this.impl$activeItemStackCopy.copy());
            return;
        }
        if (!event.itemStackResult().isValid()) {
            this.shadow$setItemInHand(hand, this.impl$activeItemStackCopy.copy());
            return;
        }
        this.shadow$setItemInHand(hand, ItemStackUtil.fromSnapshotToNative(event.itemStackResult().finalReplacement()));
    }

    @Redirect(method={"releaseUsingItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;releaseUsing(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V"))
    private void impl$onStopPlayerUsing(ItemStack stack, Level world, LivingEntity self, int duration) {
        if (this.shadow$level().isClientSide) {
            stack.releaseUsing(world, self, duration);
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
            HandType handType = (HandType)this.shadow$getUsedItemHand();
            this.impl$addSelfToFrame(frame, snapshot, handType);
            Ticks ticksDuration = SpongeTicks.ticksOrInfinite(duration);
            if (!SpongeCommon.post(SpongeEventFactory.createUseItemStackEventStop(PhaseTracker.getCauseStackManager().currentCause(), ticksDuration, ticksDuration, snapshot))) {
                stack.releaseUsing(world, self, duration);
                if (self instanceof net.minecraft.server.level.ServerPlayer) {
                    PhaseTracker.SERVER.getPhaseContext().getTransactor().logPlayerInventoryChange((Player)((net.minecraft.server.level.ServerPlayer)self), PlayerInventoryTransaction.EventCreator.STANDARD);
                    ((net.minecraft.server.level.ServerPlayer)self).inventoryMenu.broadcastChanges();
                }
            }
        }
    }

    @Inject(method={"stopUsingItem"}, at={@At(value="HEAD")})
    private void impl$onResetActiveHand(CallbackInfo ci) {
        if (this.shadow$level().isClientSide) {
            return;
        }
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(this.impl$activeItemStackCopy != null ? this.impl$activeItemStackCopy : this.useItem);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            this.impl$addSelfToFrame(frame, snapshot);
            Ticks useItemRemainingTicks = SpongeTicks.ticksOrInfinite(this.useItemRemaining);
            SpongeCommon.post(SpongeEventFactory.createUseItemStackEventReset(PhaseTracker.getCauseStackManager().currentCause(), useItemRemainingTicks, useItemRemainingTicks, snapshot));
        }
        this.impl$activeItemStackCopy = null;
    }

    @Inject(method={"canBeSeenAsEnemy"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$makeVanishable(CallbackInfoReturnable<Boolean> cir) {
        if (this instanceof VanishableBridge && this.bridge$vanishState().untargetable()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"canBeSeenByAnyone"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$ifVanishedCantBeSeenByAnyone(CallbackInfoReturnable<Boolean> cir) {
        if (this instanceof VanishableBridge && this.bridge$vanishState().untargetable()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"stopSleeping"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;clearSleepingPos()V")})
    private void impl$callFinishSleepingEvent(CallbackInfo ci) {
        if (this.shadow$level().isClientSide) {
            return;
        }
        Optional<BlockPos> sleepingPos = this.shadow$getSleepingPos();
        if (!sleepingPos.isPresent()) {
            return;
        }
        BlockSnapshot snapshot = ((ServerWorld)this.shadow$level()).createSnapshot(sleepingPos.get().getX(), sleepingPos.get().getY(), sleepingPos.get().getZ());
        Cause currentCause = Sponge.server().causeStackManager().currentCause();
        ServerLocation loc = ServerLocation.of((ServerWorld)this.shadow$level(), VecHelper.toVector3d(this.shadow$position()));
        Vector3d rot = ((Living)((Object)this)).rotation();
        SleepingEvent.Finish event = SpongeEventFactory.createSleepingEventFinish(currentCause, loc, loc, rot, rot, snapshot, (Living)((Object)this));
        Sponge.eventManager().post(event);
        this.shadow$clearSleepingPos();
        if (event.toLocation().world() != this.shadow$level()) {
            throw new UnsupportedOperationException("World change is not supported here.");
        }
        this.shadow$setPos(event.toLocation().x(), event.toLocation().y(), event.toLocation().z());
        ((Living)((Object)this)).setRotation(event.toRotation());
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/CombatTracker;recheckStatus()V", shift=At.Shift.AFTER)})
    private void impl$clearLastDamageSource(CallbackInfo ci) {
        if (this.lastDamageSource != null && this.shadow$level().getGameTime() - this.lastDamageStamp > 40L) {
            this.lastDamageSource = null;
        }
    }
}

