/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.animal;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.entity.AggressiveEntityBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.entity.AgableMobMixin;

@Mixin(value={Wolf.class})
public abstract class WolfMixin
extends AgableMobMixin
implements AggressiveEntityBridge {
    @Shadow
    public abstract void shadow$startPersistentAngerTimer();

    @Shadow
    protected abstract void shadow$tryToTame(Player var1);

    @Override
    public boolean bridge$isAngry() {
        return ((NeutralMob)this).isAngry();
    }

    @Override
    public void bridge$setAngry(boolean angry) {
        this.shadow$startPersistentAngerTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"mobInteract"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/Wolf;tryToTame(Lnet/minecraft/world/entity/player/Player;)V"))
    private void impl$onTame(Wolf instance, Player player, Player $$0, InteractionHand $$1) {
        try {
            ItemStack handStack = player.getItemInHand($$1);
            handStack.grow(1);
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(handStack);
            handStack.shrink(1);
            PhaseTracker.getCauseStackManager().pushCause(snapshot);
            this.shadow$tryToTame(player);
        }
        finally {
            PhaseTracker.getCauseStackManager().popCause();
        }
    }

    @Inject(method={"tryToTame"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/Wolf;tame(Lnet/minecraft/world/entity/player/Player;)V")}, cancellable=true)
    private void impl$onTame(Player player, CallbackInfo ci) {
        try {
            PhaseTracker.getCauseStackManager().pushCause(player);
            if (SpongeCommon.post(SpongeEventFactory.createTameEntityEvent(PhaseTracker.getCauseStackManager().currentCause(), (org.spongepowered.api.entity.living.animal.Wolf)((Object)this)))) {
                this.shadow$level().broadcastEntityEvent((Entity)((Wolf)this), (byte)6);
                ci.cancel();
            }
        }
        finally {
            PhaseTracker.getCauseStackManager().popCause();
        }
    }
}

