/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.monster;

import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.monster.Shulker;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.entity.monster.ShulkerBridge;
import org.spongepowered.common.mixin.core.world.entity.MobMixin;
import org.spongepowered.common.util.Constants;

@Mixin(value={Shulker.class})
public abstract class ShulkerMixin
extends MobMixin
implements ShulkerBridge {
    @Shadow
    @Final
    protected static EntityDataAccessor<Byte> DATA_COLOR_ID;
    @Shadow
    @Final
    protected static EntityDataAccessor<Direction> DATA_ATTACH_FACE_ID;

    @Override
    public @Nullable DyeColor bridge$getColor() {
        byte color = (Byte)this.entityData.get(DATA_COLOR_ID);
        if (color > 15) {
            return null;
        }
        return (DyeColor)net.minecraft.world.item.DyeColor.byId((int)color);
    }

    @Override
    public void bridge$setColor(@Nullable DyeColor color) {
        int value = color == null ? 16 : ((net.minecraft.world.item.DyeColor)color).getId();
        this.entityData.set(DATA_COLOR_ID, (Object)((byte)value));
    }

    @Override
    public org.spongepowered.api.util.Direction bridge$getDirection() {
        return Constants.DirectionFunctions.getFor((Direction)this.entityData.get(DATA_ATTACH_FACE_ID));
    }

    @Override
    public void bridge$setDirection(org.spongepowered.api.util.Direction direction) {
        this.entityData.set(DATA_ATTACH_FACE_ID, (Object)Constants.DirectionFunctions.getFor(direction));
    }
}

