/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.projectile;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhase;
import org.spongepowered.common.util.DirectionUtil;

@Mixin(value={ProjectileUtil.class})
public abstract class ProjectileUtilMixin {
    @Inject(method={"getHitResultOnMoveVector"}, at={@At(value="RETURN")}, cancellable=true)
    private static void impl$onGetHitResultOnMoveVector(Entity entity, Predicate<Entity> $$1, CallbackInfoReturnable<HitResult> cir) {
        if (!ShouldFire.COLLIDE_BLOCK_EVENT_MOVE) {
            return;
        }
        HitResult hitResult = (HitResult)cir.getReturnValue();
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockState state = entity.level().getBlockState(blockHitResult.getBlockPos());
            if (SpongeCommonEventFactory.handleCollideBlockEvent(state.getBlock(), entity.level(), blockHitResult.getBlockPos(), state, entity, DirectionUtil.getFor(blockHitResult.getDirection()), SpongeCommonEventFactory.CollisionType.MOVE)) {
                Vec3 from = entity.position();
                Vec3 velocity = entity.getDeltaMovement();
                Vec3 to = from.add(velocity);
                Vec3 direction = from.subtract(to);
                cir.setReturnValue((Object)BlockHitResult.miss((Vec3)to, (Direction)Direction.getNearest((double)direction.x, (double)direction.y, (double)direction.z), (BlockPos)BlockPos.containing((Position)to)));
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"getHitResult(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/entity/Entity;Ljava/util/function/Predicate;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;FLnet/minecraft/world/level/ClipContext$Block;)Lnet/minecraft/world/phys/HitResult;", "getEntityHitResult(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Lnet/minecraft/world/phys/EntityHitResult;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ProjectileUtil;getEntityHitResult(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;F)Lnet/minecraft/world/phys/EntityHitResult;"))
    private static EntityHitResult impl$onGetEntityHitResult(Level $$0, Entity $$1, Vec3 $$2, Vec3 $$3, AABB $$4, Predicate<Entity> $$5, float $$6) {
        if ($$0.isClientSide) {
            return ProjectileUtil.getEntityHitResult((Level)$$0, (Entity)$$1, (Vec3)$$2, (Vec3)$$3, (AABB)$$4, $$5, (float)$$6);
        }
        try (@NonNull P context = EntityPhase.State.COLLISION.createPhaseContext(PhaseTracker.SERVER).source($$1);){
            ((PhaseContext)context).buildAndSwitch();
            EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Level)$$0, (Entity)$$1, (Vec3)$$2, (Vec3)$$3, (AABB)$$4, $$5, (float)$$6);
            return entityHitResult;
        }
    }
}

