/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.projectile.ProjectileMixin;

@Mixin(value={ThrowableProjectile.class})
public abstract class ThrowableProjectileMixin
extends ProjectileMixin {
    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ThrowableProjectile;hitTargetOrDeflectSelf(Lnet/minecraft/world/phys/HitResult;)Lnet/minecraft/world/entity/projectile/ProjectileDeflection;"))
    private ProjectileDeflection impl$handleProjectileImpact(ThrowableProjectile projectile, HitResult movingObjectPosition) {
        if (((LevelBridge)this.shadow$level()).bridge$isFake() || movingObjectPosition.getType() == HitResult.Type.MISS) {
            return this.shadow$hitTargetOrDeflectSelf(movingObjectPosition);
        }
        if (SpongeCommonEventFactory.handleCollideImpactEvent((Entity)projectile, this.impl$getProjectileSource(), movingObjectPosition)) {
            this.shadow$discard();
            return ProjectileDeflection.NONE;
        }
        return this.shadow$hitTargetOrDeflectSelf(movingObjectPosition);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/TheEndGatewayBlockEntity;teleportEntity(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/block/entity/TheEndGatewayBlockEntity;)V"))
    private void impl$createCauseFrameForGatewayTeleport(Level level, BlockPos pos, BlockState state, Entity self, TheEndGatewayBlockEntity gateway) {
        if (this.shadow$getCommandSenderWorld().isClientSide) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(gateway);
            frame.pushCause(self);
            TheEndGatewayBlockEntity.teleportEntity((Level)level, (BlockPos)pos, (BlockState)state, (Entity)self, (TheEndGatewayBlockEntity)gateway);
        }
    }
}

