/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.food;

import java.util.Objects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.data.ChangeDataHolderEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.food.FoodDataBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={FoodData.class})
public abstract class FoodDataMixin
implements FoodDataBridge {
    @Shadow
    private int foodLevel;
    @Shadow
    private float saturationLevel;
    @Shadow
    private float exhaustionLevel;
    private Player impl$player;

    @Override
    public void bridge$setPlayer(Player player) {
        this.impl$player = player;
    }

    @Redirect(method={"setFoodLevel"}, at=@At(value="FIELD", target="Lnet/minecraft/world/food/FoodData;foodLevel:I", opcode=181))
    private void impl$setFoodLevel(FoodData self, int value) {
        this.foodLevel = this.impl$fireEventAndGetValue(Keys.FOOD_LEVEL, this.foodLevel, value);
    }

    @Redirect(method={"add"}, at=@At(value="FIELD", target="Lnet/minecraft/world/food/FoodData;foodLevel:I", opcode=181))
    private void impl$eatSetFoodLevel(FoodData self, int value) {
        this.foodLevel = this.impl$fireEventAndGetValue(Keys.FOOD_LEVEL, this.foodLevel, value);
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lnet/minecraft/world/food/FoodData;foodLevel:I", opcode=181))
    private void impl$tickDrainFoodLevel(FoodData self, int value) {
        this.foodLevel = this.impl$fireEventAndGetValue(Keys.FOOD_LEVEL, this.foodLevel, value);
    }

    @Redirect(method={"setSaturation"}, at=@At(value="FIELD", target="Lnet/minecraft/world/food/FoodData;saturationLevel:F", opcode=181))
    private void impl$setSaturationLevel(FoodData self, float value) {
        this.saturationLevel = this.impl$fireEventAndGetValue(Keys.SATURATION, Double.valueOf(this.saturationLevel), Double.valueOf(value)).floatValue();
    }

    @Redirect(method={"add"}, at=@At(value="FIELD", target="Lnet/minecraft/world/food/FoodData;saturationLevel:F", opcode=181))
    private void impl$eatSetSaturationLevel(FoodData self, float value) {
        this.saturationLevel = this.impl$fireEventAndGetValue(Keys.SATURATION, Double.valueOf(this.saturationLevel), Double.valueOf(value)).floatValue();
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lnet/minecraft/world/food/FoodData;saturationLevel:F", opcode=181))
    private void impl$tickDrainSaturationLevel(FoodData self, float value) {
        this.saturationLevel = this.impl$fireEventAndGetValue(Keys.SATURATION, Double.valueOf(this.saturationLevel), Double.valueOf(value)).floatValue();
    }

    @Redirect(method={"setExhaustion"}, at=@At(value="FIELD", target="Lnet/minecraft/world/food/FoodData;exhaustionLevel:F", opcode=181))
    private void impl$setExhaustion(FoodData self, float value) {
        this.exhaustionLevel = this.impl$fireEventAndGetValue(Keys.EXHAUSTION, Double.valueOf(this.exhaustionLevel), Double.valueOf(value)).floatValue();
    }

    @Redirect(method={"addExhaustion"}, at=@At(value="FIELD", target="Lnet/minecraft/world/food/FoodData;exhaustionLevel:F", opcode=181))
    private void impl$addExhaustion(FoodData self, float value) {
        this.exhaustionLevel = this.impl$fireEventAndGetValue(Keys.EXHAUSTION, Double.valueOf(this.exhaustionLevel), Double.valueOf(value)).floatValue();
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lnet/minecraft/world/food/FoodData;exhaustionLevel:F", opcode=181))
    private void impl$tickDrainExhaustion(FoodData self, float value) {
        this.exhaustionLevel = this.impl$fireEventAndGetValue(Keys.EXHAUSTION, Double.valueOf(this.exhaustionLevel), Double.valueOf(value)).floatValue();
    }

    private <E> E impl$fireEventAndGetValue(Key<? extends Value<E>> key, E currentValue, E value) {
        if (!ShouldFire.CHANGE_DATA_HOLDER_EVENT_VALUE_CHANGE || Objects.equals(currentValue, value)) {
            return value;
        }
        DataTransactionResult transaction = DataTransactionResult.builder().replace(Value.immutableOf(key, currentValue)).success(Value.immutableOf(key, value)).result(DataTransactionResult.Type.SUCCESS).build();
        ChangeDataHolderEvent.ValueChange event = SpongeEventFactory.createChangeDataHolderEventValueChange(PhaseTracker.getCauseStackManager().currentCause(), transaction, (DataHolder.Mutable)this.impl$player);
        Sponge.eventManager().post(event);
        if (event.isCancelled()) {
            return currentValue;
        }
        return (E)event.endResult().successfulValue(key).map(Value::get).orElse(currentValue);
    }
}

