/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.level.NaturalSpawnerAccessor;
import org.spongepowered.common.bridge.world.level.NaturalSpawner_SpawnStateBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.SpawnerCategory;
import org.spongepowered.common.config.inheritable.WorldConfig;

@Mixin(value={NaturalSpawner.SpawnState.class})
public abstract class NaturalSpawner_SpawnStateMixin
implements NaturalSpawner_SpawnStateBridge {
    @Shadow
    @Final
    private int spawnableChunkCount;
    @Shadow
    @Final
    private Object2IntOpenHashMap<MobCategory> mobCategoryCounts;

    @Override
    public boolean bridge$canSpawnForCategoryInWorld(MobCategory classification, ServerLevel world) {
        SpawnerCategory.SpawnLimitsSubCategory spawnLimits = ((WorldConfig)SpongeGameConfigs.getForWorld((Level)world).get()).spawner.spawnLimits;
        int i = (switch (classification) {
            case MobCategory.MONSTER -> spawnLimits.monster;
            case MobCategory.CREATURE -> spawnLimits.creature;
            case MobCategory.AMBIENT -> spawnLimits.ambient;
            case MobCategory.UNDERGROUND_WATER_CREATURE -> spawnLimits.undergroundAquaticCreature;
            case MobCategory.WATER_CREATURE -> spawnLimits.aquaticCreature;
            case MobCategory.WATER_AMBIENT -> spawnLimits.aquaticAmbient;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(classification));
        }) * this.spawnableChunkCount / NaturalSpawnerAccessor.accessor$MAGIC_NUMBER();
        return this.mobCategoryCounts.getInt((Object)classification) < i;
    }
}

