/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.storage;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.PlayerDataStorage;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.util.FileUtil;

@Mixin(value={PlayerDataStorage.class})
public abstract class PlayerDataStorageMixin {
    @Shadow
    @Final
    private File playerDir;
    private @Nullable Exception impl$capturedException;

    @Redirect(method={"lambda$load$1"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;load(Lnet/minecraft/nbt/CompoundTag;)V"))
    private void impl$readSpongePlayerData(Player playerEntity, CompoundTag compound) throws IOException {
        playerEntity.load(compound);
        Path file = new File(this.playerDir, playerEntity.getStringUUID() + ".dat").toPath();
        Instant creationTime = Files.exists(file, new LinkOption[0]) ? Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).creationTime().toInstant() : null;
        ((SpongeServer)SpongeCommon.server()).getPlayerDataManager().readPlayerData(compound, null, creationTime);
    }

    @Redirect(method={"load(Lnet/minecraft/world/entity/player/Player;Ljava/lang/String;)Ljava/util/Optional;"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/NbtIo;readCompressed(Ljava/nio/file/Path;Lnet/minecraft/nbt/NbtAccounter;)Lnet/minecraft/nbt/CompoundTag;"))
    private CompoundTag impl$wrapFileRead(Path path, NbtAccounter accounter) throws IOException {
        try {
            return NbtIo.readCompressed((Path)path, (NbtAccounter)accounter);
        }
        catch (IOException exception) {
            FileUtil.copyCorruptedFile(path);
            throw exception;
        }
    }

    @Inject(method={"load(Lnet/minecraft/world/entity/player/Player;Ljava/lang/String;)Ljava/util/Optional;"}, at={@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void impl$onFailedLoad(Player param0, String param1, CallbackInfoReturnable<Optional<CompoundTag>> cir, File file, Exception exception) {
        throw new RuntimeException(exception);
    }

    @Inject(method={"save"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/NbtIo;writeCompressed(Lnet/minecraft/nbt/CompoundTag;Ljava/nio/file/Path;)V", shift=At.Shift.AFTER)})
    private void impl$saveSpongePlayerData(Player player, CallbackInfo callbackInfo) {
        ((SpongeServer)Sponge.server()).getPlayerDataManager().saveSpongePlayerData(player.getUUID());
    }

    @Inject(method={"save"}, at={@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V", remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void impl$trackExceptionForLogging(Player player, CallbackInfo ci, Exception exception) {
        this.impl$capturedException = exception;
    }

    @Redirect(method={"save"}, at=@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V", remap=false))
    private void impl$useStoredException(Logger logger, String message, Object param) {
        logger.warn(message, param, (Object)this.impl$capturedException);
        this.impl$capturedException = null;
    }
}

