/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.world.level.block.entity;

import java.util.stream.IntStream;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.accessor.world.level.block.entity.HopperBlockEntityAccessor;
import org.spongepowered.common.bridge.world.inventory.ViewableInventoryBridge;
import org.spongepowered.common.bridge.world.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.util.InventoryUtil;

@Mixin(value={HopperBlockEntity.class})
public abstract class HopperBlockEntityMixin_Inventory {
    @Redirect(method={"suckInItems"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;getSlots(Lnet/minecraft/world/Container;Lnet/minecraft/core/Direction;)[I"))
    private static int[] impl$throwTransferPreIfNotEmpty(Container inventory, Direction facing, Level level, Hopper hopper) {
        int[] slots = HopperBlockEntityAccessor.invoker$getSlots(inventory, facing);
        boolean isEmpty = IntStream.of(slots).allMatch(slot -> inventory.getItem(slot).isEmpty());
        if (isEmpty || !ShouldFire.TRANSFER_INVENTORY_EVENT_PRE) {
            return slots;
        }
        if (InventoryEventFactory.callTransferPre(InventoryUtil.toInventory(inventory), InventoryUtil.toInventory((Container)hopper)).isCancelled()) {
            return new int[0];
        }
        return slots;
    }

    @Redirect(method={"addItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/Container;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Lnet/minecraft/world/item/ItemStack;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;tryMoveInItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/Container;Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/core/Direction;)Lnet/minecraft/world/item/ItemStack;"))
    private static ItemStack impl$throwEventsForInsertion(Container source, Container destination, ItemStack stack, int index, Direction direction) {
        if (!(source instanceof TrackedInventoryBridge) && !(destination instanceof TrackedInventoryBridge) || !(destination instanceof InventoryAdapter)) {
            return HopperBlockEntityAccessor.invoker$tryMoveInItem(source, destination, stack, index, direction);
        }
        if (!ShouldFire.TRANSFER_INVENTORY_EVENT_POST) {
            return HopperBlockEntityAccessor.invoker$tryMoveInItem(source, destination, stack, index, direction);
        }
        TrackedInventoryBridge captureIn = InventoryUtil.forCapture(source);
        if (captureIn == null) {
            captureIn = InventoryUtil.forCapture(destination);
        }
        return InventoryEventFactory.captureTransaction(captureIn, InventoryUtil.toInventory(destination), index, () -> HopperBlockEntityAccessor.invoker$tryMoveInItem(source, destination, stack, index, direction));
    }

    @Inject(method={"tryTakeInItemFromSlot"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal=1)})
    private static void imlp$throwTransferEventsWhenPullingItems(Hopper hopper, Container iInventory, int index, Direction direction, CallbackInfoReturnable<Boolean> cir, ItemStack itemStack, int oldCount, ItemStack itemstack2) {
        ViewableInventoryBridge bridge;
        if (ShouldFire.TRANSFER_INVENTORY_EVENT_POST && itemstack2.isEmpty()) {
            TrackedInventoryBridge capture = InventoryUtil.forCapture(hopper);
            int newCount = itemStack.getCount();
            itemstack2.setCount(oldCount);
            ItemStack itemStack1 = itemstack2.copy();
            itemstack2.setCount(newCount);
            SlotTransaction sourceSlotTransaction = InventoryEventFactory.captureTransaction(capture, InventoryUtil.toInventory(iInventory), index, itemStack1);
            InventoryEventFactory.callTransferPost(capture, InventoryUtil.toInventory(iInventory), InventoryUtil.toInventory((Container)hopper), itemStack1, sourceSlotTransaction);
        }
        if (hopper instanceof ViewableInventoryBridge) {
            bridge = (ViewableInventoryBridge)hopper;
            try (Object context = BlockPhase.State.RESTORING_BLOCKS.createPhaseContext(PhaseTracker.SERVER);){
                ((PhaseContext)context).buildAndSwitch();
                for (ServerPlayer player : bridge.viewableBridge$getViewers()) {
                    player.containerMenu.broadcastChanges();
                }
            }
        }
        if (iInventory instanceof ViewableInventoryBridge) {
            bridge = (ViewableInventoryBridge)iInventory;
            try (Object context = BlockPhase.State.RESTORING_BLOCKS.createPhaseContext(PhaseTracker.SERVER);){
                ((PhaseContext)context).buildAndSwitch();
                for (ServerPlayer player : bridge.viewableBridge$getViewers()) {
                    player.containerMenu.broadcastChanges();
                }
            }
        }
    }

    @Redirect(method={"addItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/entity/item/ItemEntity;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;addItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/Container;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Lnet/minecraft/world/item/ItemStack;"))
    private static ItemStack impl$onPutStackInInventoryAllSlots(Container source, Container destination, ItemStack stack, Direction direction, Container d2, ItemEntity entity) {
        return InventoryEventFactory.callHopperInventoryPickupEvent(destination, entity, stack);
    }
}

