/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.applaunch.config.common.CommonConfig;
import org.spongepowered.common.applaunch.config.common.OptimizationCategory;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.mixin.plugin.AbstractMixinConfigPlugin;

public class OptimizationPlugin
extends AbstractMixinConfigPlugin {
    private static final Map<String, Function<OptimizationCategory, Boolean>> mixinEnabledMappings = ImmutableMap.builder().put((Object)"org.spongepowered.common.mixin.optimization.general.DataFixersMixin_Optimization_LazyDFU", optimizationCategory -> optimizationCategory.enableLazyDFU).put((Object)"org.spongepowered.common.mixin.optimization.world.entity.TamableAnimalMixin_Optimization_Owner", optimizationCategory -> optimizationCategory.cacheTameableOwners).put((Object)"org.spongepowered.common.mixin.optimization.world.level.block.entity.BellBlockEntityMixin_Optimization_BellLeak", optimizationCategory -> optimizationCategory.bellLeak).build();

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        CommonConfig globalConfig = SpongeConfigs.getCommon().get();
        if (globalConfig.modules.optimizations) {
            Function<OptimizationCategory, Boolean> optimizationCategoryBooleanFunction = mixinEnabledMappings.get(mixinClassName);
            if (optimizationCategoryBooleanFunction == null) {
                new PrettyPrinter(50).add("Could not find function for optimization patch").centre().hr().add("Missing function for class: " + mixinClassName).trace();
                return false;
            }
            return optimizationCategoryBooleanFunction.apply(globalConfig.optimizations);
        }
        return false;
    }
}

