/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.entity;

import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.scores.PlayerTeam;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.DelegatingConfigTrackableBridge;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.world.entity.TrackableEntityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;

@Mixin(value={net.minecraft.world.entity.Entity.class})
public abstract class EntityMixin_Tracker
implements DelegatingConfigTrackableBridge,
TrackableEntityBridge {
    @Shadow
    @Final
    private EntityType<?> type;
    @Shadow
    @Final
    protected RandomSource random;
    @Shadow
    private EntityInLevelCallback levelCallback;
    protected @MonotonicNonNull EffectTransactor tracker$dropsTransactor = null;

    @Shadow
    public abstract @Nullable PlayerTeam getTeam();

    @Shadow
    public abstract UUID shadow$getUUID();

    @Shadow
    public abstract double shadow$getEyeY();

    @Shadow
    public abstract double shadow$getX();

    @Shadow
    public abstract double shadow$getY();

    @Shadow
    public abstract double shadow$getZ();

    @Shadow
    public abstract void shadow$remove(Entity.RemovalReason var1);

    @Shadow
    public abstract float shadow$getXRot();

    @Shadow
    public abstract float shadow$getYRot();

    @Shadow
    public abstract boolean shadow$isEffectiveAi();

    @Shadow
    public abstract Level shadow$level();

    @Inject(method={"spawnAtLocation(Lnet/minecraft/world/item/ItemStack;F)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="HEAD")})
    private void tracker$logEntityDropTransactionIfNecessary(ItemStack stack, float offsetY, CallbackInfoReturnable<ItemEntity> cir) {
        PhaseTracker instance = PhaseTracker.SERVER;
        if (!instance.onSidedThread()) {
            return;
        }
        if (((LevelBridge)this.shadow$level()).bridge$isFake()) {
            return;
        }
        PhaseContext<@NonNull ?> context = instance.getPhaseContext();
        if (!context.doesBlockEventTracking()) {
            return;
        }
        if (this.tracker$dropsTransactor == null) {
            this.tracker$dropsTransactor = context.getTransactor().ensureEntityDropTransactionEffect((net.minecraft.world.entity.Entity)this);
        }
    }

    @Inject(method={"setRemoved(Lnet/minecraft/world/entity/Entity$RemovalReason;)V"}, at={@At(value="RETURN")})
    private void tracker$ensureDropEffectCompleted(Entity.RemovalReason reason, CallbackInfo ci) {
        PhaseTracker instance = PhaseTracker.SERVER;
        if (!instance.onSidedThread()) {
            return;
        }
        if (((LevelBridge)this.shadow$level()).bridge$isFake()) {
            return;
        }
        PhaseContext<@NonNull ?> context = instance.getPhaseContext();
        if (!context.doesBlockEventTracking()) {
            return;
        }
        if (this.tracker$dropsTransactor != null) {
            this.tracker$dropsTransactor.close();
        }
    }

    @Override
    public final void tracker$populateFrameInTickContext(CauseStackManager.StackFrame frame, EntityTickContext context) {
        this.tracker$populateDeathContextIfNeeded(frame, context);
    }

    protected void tracker$populateDeathContextIfNeeded(CauseStackManager.StackFrame frame, EntityTickContext context) {
    }

    @Inject(method={"setRemoved"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;stopRiding()V")})
    private void impl$createDestructionEventOnDeath(CallbackInfo ci) {
        if (ShouldFire.DESTRUCT_ENTITY_EVENT && !((LevelBridge)this.shadow$level()).bridge$isFake() && this.levelCallback != EntityInLevelCallback.NULL) {
            if (!((net.minecraft.world.entity.Entity)this instanceof LivingEntity)) {
                Cause cause = PhaseTracker.getCauseStackManager().currentCause();
                Audience originalChannel = Audience.empty();
                SpongeCommon.post(SpongeEventFactory.createDestructEntityEvent(cause, originalChannel, Optional.of(originalChannel), (Component)Component.empty(), (Component)Component.empty(), (Entity)((Object)this), false));
            } else if ((net.minecraft.world.entity.Entity)this instanceof ArmorStand) {
                SpongeCommonEventFactory.callDestructEntityEventDeath((LivingEntity)((ArmorStand)this), null);
            }
        }
    }

    @Override
    public TrackableBridge bridge$trackingConfigDelegate() {
        return (TrackableBridge)this.type;
    }
}

