/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network;

import com.mojang.authlib.GameProfile;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionState;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.profile.SpongeGameProfile;

public abstract class SpongeEngineConnection
implements EngineConnection {
    protected final Connection connection;
    private final AtomicReference<EventFireState> eventFireState;
    private @MonotonicNonNull GameProfile gameProfile;

    public SpongeEngineConnection(Connection connection) {
        this.connection = connection;
        this.eventFireState = new AtomicReference<EventFireState>(EventFireState.NONE);
    }

    @Override
    public boolean active() {
        return this.connection.isConnected();
    }

    @Override
    public Optional<EngineConnectionState> state() {
        if (this.active()) {
            return Optional.of((EngineConnectionState)this.connection.getPacketListener());
        }
        return Optional.empty();
    }

    @Override
    public InetSocketAddress address() {
        return ((ConnectionBridge)this.connection).bridge$getAddress();
    }

    @Override
    public InetSocketAddress virtualHost() {
        return ((ConnectionBridge)this.connection).bridge$getVirtualHost();
    }

    @Override
    public void close() {
        this.connection.disconnect((Component)Component.translatable((String)"disconnect.disconnected"));
    }

    @Override
    public void close(net.kyori.adventure.text.Component reason) {
        this.connection.disconnect(SpongeAdventure.asVanilla(reason));
    }

    public void setGameProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
    }

    public Connection connection() {
        return this.connection;
    }

    public void disconnected() {
        if (this.eventFireState.getAndSet(EventFireState.DISCONNECTED).shouldFireDisconnectionImmediately()) {
            this.fireDisconnectEvent();
        }
    }

    public boolean postGuardedEvent(ServerSideConnectionEvent event) {
        Cancellable cancellable;
        if (!this.eventFireState.compareAndSet(EventFireState.NONE, EventFireState.IN_FLIGHT) && !this.eventFireState.compareAndSet(EventFireState.POST, EventFireState.IN_FLIGHT)) {
            return false;
        }
        SpongeCommon.post(event);
        if (!this.eventFireState.compareAndSet(EventFireState.IN_FLIGHT, EventFireState.POST)) {
            this.fireDisconnectEvent();
        }
        return event instanceof Cancellable && (cancellable = (Cancellable)((Object)event)).isCancelled();
    }

    private void fireDisconnectEvent() {
        this.eventFireState.set(EventFireState.DISCONNECTED);
        ServerSideConnectionEvent.Disconnect event = SpongeEventFactory.createServerSideConnectionEventDisconnect(PhaseTracker.getCauseStackManager().currentCause(), (ServerSideConnection)((Object)this), Optional.ofNullable(this.gameProfile).map(SpongeGameProfile::of));
        SpongeCommon.post(event);
    }

    private static enum EventFireState {
        NONE,
        IN_FLIGHT,
        POST,
        DISCONNECTED;


        boolean shouldFireDisconnectionImmediately() {
            return this == POST;
        }
    }
}

