/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import java.util.Objects;
import java.util.StringJoiner;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.api.registry.RegistryKey;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.registry.RegistryType;

public final class SpongeRegistryEntry<T>
implements RegistryEntry<T> {
    private final RegistryType<T> registryType;
    private final ResourceKey key;
    private final T value;

    public SpongeRegistryEntry(RegistryType<T> registryType, ResourceKey key, T value) {
        this.registryType = registryType;
        this.key = Objects.requireNonNull(key, "key");
        this.value = Objects.requireNonNull(value, "value");
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    @Override
    public T value() {
        return this.value;
    }

    @Override
    public RegistryReference<T> asReference() {
        return RegistryKey.of(this.registryType, this.key).asReference();
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeRegistryEntry other = (SpongeRegistryEntry)o;
        return this.key.equals(other.key);
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("key='" + String.valueOf(this.key) + "'").add("value='" + String.valueOf(this.value) + "'").toString();
    }
}

