/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.KeyValueMatcher;
import org.spongepowered.api.state.State;
import org.spongepowered.api.state.StateContainer;
import org.spongepowered.api.state.StateMatcher;
import org.spongepowered.api.state.StateProperty;

public abstract class AbstractStateMatcherBuilder<S extends State<@NonNull S>, T extends StateContainer<@NonNull S>>
implements StateMatcher.Builder<S, T> {
    final Collection<StateProperty<@NonNull ?>> requiredProperties = new ArrayList();
    final Map<StateProperty<@NonNull ?>, Object> properties = new HashMap();
    final Collection<KeyValueMatcher<?>> keyValueMatchers = new ArrayList();
    @Nullable T type;

    @Override
    public @NonNull StateMatcher.Builder<@NonNull S, @NonNull T> type(@NonNull T type) {
        this.type = type;
        return this;
    }

    @Override
    public @NonNull StateMatcher.Builder<@NonNull S, @NonNull T> supportsStateProperty(@NonNull StateProperty<@NonNull ?> stateProperty) {
        this.requiredProperties.add(stateProperty);
        return this;
    }

    @Override
    public <V extends Comparable<V>> @NonNull StateMatcher.Builder<@NonNull S, @NonNull T> stateProperty(@NonNull StateProperty<@NonNull V> stateProperty, @NonNull V value) {
        this.properties.put(stateProperty, value);
        return this;
    }

    @Override
    public @NonNull StateMatcher.Builder<@NonNull S, @NonNull T> matcher(@NonNull KeyValueMatcher<?> matcher) {
        this.keyValueMatchers.add(matcher);
        return this;
    }

    @Override
    public @NonNull StateMatcher.Builder<@NonNull S, @NonNull T> reset() {
        this.type = null;
        this.properties.clear();
        this.requiredProperties.clear();
        this.keyValueMatchers.clear();
        return this;
    }

    @Override
    public @NonNull StateMatcher.Builder<@NonNull S, @NonNull T> from(@NonNull StateMatcher<@NonNull S> value) {
        AbstractStateMatcherBuilder that = (AbstractStateMatcherBuilder)((Object)value);
        this.type = that.type;
        this.properties.clear();
        this.properties.putAll(that.properties);
        this.requiredProperties.clear();
        this.requiredProperties.addAll(that.requiredProperties);
        this.keyValueMatchers.clear();
        this.keyValueMatchers.addAll(that.keyValueMatchers);
        return this;
    }
}

