/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.state;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.StateHolder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.KeyValueMatcher;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.state.StateProperty;
import org.spongepowered.common.state.AbstractSpongeStateMatcher;

public final class SpongeFluidStateMatcher
extends AbstractSpongeStateMatcher<FluidState, FluidType> {
    public SpongeFluidStateMatcher(FluidType type, Collection<StateProperty<@NonNull ?>> requiredProperties, HashMap<StateProperty<@NonNull ?>, Object> properties, Collection<KeyValueMatcher<?>> keyValueMatchers) {
        super(type, requiredProperties, properties, keyValueMatchers);
    }

    @Override
    public boolean matches(@NonNull FluidState state) {
        return this.isValid((StateHolder)state);
    }

    @Override
    public @NonNull List<FluidState> compatibleStates() {
        if (this.compatibleStates == null) {
            Block blockType = (Block)this.type;
            this.compatibleStates = blockType.getStateDefinition().getPossibleStates().stream().filter(this::isValid).map(x -> (FluidState)x).collect(Collectors.toList());
        }
        return this.compatibleStates;
    }
}

