/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import org.spongepowered.api.Server;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.FallingBlock;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierTypes;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.world.entity.LivingEntityAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.damagesource.DamageSourceBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;

public final class DamageEventUtil {
    public static final DoubleUnaryOperator HARD_HAT_FUNCTION = damage -> -(damage - damage * 0.75);

    private DamageEventUtil() {
    }

    public static DoubleUnaryOperator createResistanceFunction(int resistanceAmplifier) {
        int base = (resistanceAmplifier + 1) * 5;
        int modifier = 25 - base;
        return damage -> -(damage - Math.max(damage * (double)modifier / 25.0, 0.0));
    }

    public static Optional<DamageFunction> createHardHatModifier(LivingEntity living, DamageSource damageSource) {
        if (damageSource.getDirectEntity() instanceof FallingBlock && !living.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), ((org.spongepowered.api.item.inventory.ItemStack)living.getItemBySlot(EquipmentSlot.HEAD)).createSnapshot())).type(DamageModifierTypes.HARD_HAT).build();
            return Optional.of(new DamageFunction(modifier, HARD_HAT_FUNCTION));
        }
        return Optional.empty();
    }

    public static Optional<DamageFunction> createArmorModifiers(LivingEntity living, DamageSource damageSource) {
        DamageFunction armorModifier;
        if (damageSource.is(DamageTypeTags.BYPASSES_ARMOR)) {
            return Optional.empty();
        }
        DoubleUnaryOperator function = incomingDamage -> -(incomingDamage - (double)CombatRules.getDamageAfterAbsorb((float)((float)incomingDamage), (DamageSource)damageSource, (float)living.getArmorValue(), (float)((float)living.getAttributeValue(Attributes.ARMOR_TOUGHNESS))));
        try (CauseStackManager.StackFrame frame = ((Server)living.getServer()).causeStackManager().pushCauseFrame();){
            frame.pushCause(living);
            frame.pushCause(Attributes.ARMOR_TOUGHNESS);
            armorModifier = DamageFunction.of(DamageModifier.builder().cause(frame.currentCause()).type(DamageModifierTypes.ARMOR).build(), function);
        }
        return Optional.of(armorModifier);
    }

    public static Optional<DamageFunction> createResistanceModifier(LivingEntity living, DamageSource damageSource) {
        PotionEffect effect = (PotionEffect)living.getEffect(MobEffects.DAMAGE_RESISTANCE);
        if (effect != null && !damageSource.is(DamageTypeTags.BYPASSES_EFFECTS) && !damageSource.is(DamageTypeTags.BYPASSES_RESISTANCE)) {
            return Optional.of(new DamageFunction(DamageModifier.builder().cause(Cause.of(EventContext.empty(), effect)).type(DamageModifierTypes.DEFENSIVE_POTION_EFFECT).build(), DamageEventUtil.createResistanceFunction(effect.amplifier())));
        }
        return Optional.empty();
    }

    public static Optional<List<DamageFunction>> createEnchantmentModifiers(LivingEntity living, DamageSource damageSource) {
        if (damageSource.is(DamageTypeTags.BYPASSES_ENCHANTMENTS)) {
            return Optional.empty();
        }
        Iterable inventory = living.getArmorSlots();
        int damageProtection = EnchantmentHelper.getDamageProtection((Iterable)inventory, (DamageSource)damageSource);
        if (damageProtection <= 0) {
            return Optional.empty();
        }
        ArrayList<DamageFunction> modifiers = new ArrayList<DamageFunction>();
        DoubleUnaryOperator enchantmentFunction = incomingDamage -> -(incomingDamage - (double)CombatRules.getDamageAfterMagicAbsorb((float)((float)incomingDamage), (float)damageProtection));
        try (CauseStackManager.StackFrame frame = ((Server)living.getServer()).causeStackManager().pushCauseFrame();){
            frame.pushCause(living);
            DamageModifier enchantmentModifier = DamageModifier.builder().cause(frame.currentCause()).type(DamageModifierTypes.ARMOR_ENCHANTMENT).build();
            modifiers.add(new DamageFunction(enchantmentModifier, enchantmentFunction));
        }
        return Optional.of(modifiers);
    }

    public static Optional<DamageFunction> createAbsorptionModifier(LivingEntity living) {
        float absorptionAmount = living.getAbsorptionAmount();
        if (absorptionAmount > 0.0f) {
            DoubleUnaryOperator function = damage -> -Math.max(damage - Math.max(damage - (double)absorptionAmount, 0.0), 0.0);
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), living)).type(DamageModifierTypes.ABSORPTION).build();
            return Optional.of(new DamageFunction(modifier, function));
        }
        return Optional.empty();
    }

    public static ServerLocation findFirstMatchingBlock(net.minecraft.world.entity.Entity entity, AABB bb, Predicate<BlockState> predicate) {
        int i = Mth.floor((double)bb.minX);
        int j = Mth.floor((double)(bb.maxX + 1.0));
        int k = Mth.floor((double)bb.minY);
        int l = Mth.floor((double)(bb.maxY + 1.0));
        int i1 = Mth.floor((double)bb.minZ);
        int j1 = Mth.floor((double)(bb.maxZ + 1.0));
        ChunkSource chunkSource = entity.level().getChunkSource();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockPos blockPos = new BlockPos(k1, l1, i2);
                    LevelChunk chunk = chunkSource.getChunk(blockPos.getX() >> 4, blockPos.getZ() >> 4, false);
                    if (chunk == null || chunk.isEmpty() || !predicate.test(chunk.getBlockState(blockPos))) continue;
                    return ServerLocation.of((ServerWorld)entity.level(), k1, l1, i2);
                }
            }
        }
        return ((Entity)entity).serverLocation();
    }

    public static void generateCauseFor(DamageSource damageSource, CauseStackManager.StackFrame frame) {
        net.minecraft.world.entity.Entity entity = damageSource.getDirectEntity();
        if (entity instanceof Entity) {
            Entity entity2 = (Entity)entity;
            if (!(entity2 instanceof Player) && entity2 instanceof CreatorTrackedBridge) {
                CreatorTrackedBridge creatorBridge = (CreatorTrackedBridge)((Object)entity2);
                creatorBridge.tracker$getCreatorUUID().ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
                creatorBridge.tracker$getNotifierUUID().ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            }
        } else if (((DamageSourceBridge)damageSource).bridge$blockLocation() != null) {
            ServerLocation location = ((DamageSourceBridge)damageSource).bridge$blockLocation();
            BlockPos blockPos = VecHelper.toBlockPos(location);
            LevelChunkBridge chunkBridge = (LevelChunkBridge)((Level)location.world()).getChunkAt(blockPos);
            chunkBridge.bridge$getBlockCreatorUUID(blockPos).ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
            chunkBridge.bridge$getBlockNotifierUUID(blockPos).ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
        }
        frame.pushCause(damageSource);
    }

    public static List<DamageFunction> createAttackEnchantmentFunction(ItemStack heldItem, EntityType<?> entityType, float attackStrength) {
        if (heldItem.isEmpty()) {
            return Collections.emptyList();
        }
        ItemEnchantments enchantmentCompounds = (ItemEnchantments)heldItem.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        if (enchantmentCompounds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DamageFunction> damageModifierFunctions = new ArrayList<DamageFunction>();
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(heldItem);
        for (Object2IntMap.Entry entry : enchantmentCompounds.entrySet()) {
            Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
            int level = entry.getIntValue();
            DamageModifier enchantmentModifier = DamageModifier.builder().type(DamageModifierTypes.WEAPON_ENCHANTMENT).cause(Cause.of(EventContext.empty(), snapshot, enchantment)).build();
            DoubleUnaryOperator enchantmentFunction = damage -> {
                double totalDamage = 0.0;
                return totalDamage += (double)(enchantment.getDamageBonus(level, entityType) * attackStrength);
            };
            damageModifierFunctions.add(new DamageFunction(enchantmentModifier, enchantmentFunction));
        }
        return damageModifierFunctions;
    }

    public static DamageFunction provideCriticalAttackTuple(Player player, double criticalModifier) {
        DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), player)).type(DamageModifierTypes.CRITICAL_HIT).build();
        DoubleUnaryOperator function = damage -> damage * criticalModifier;
        return new DamageFunction(modifier, function);
    }

    public static DamageFunction provideCooldownAttackStrengthFunction(Player player, float attackStrength) {
        DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), player)).type(DamageModifierTypes.ATTACK_COOLDOWN).build();
        DoubleUnaryOperator function = damage -> -damage + damage * (double)(0.2f + attackStrength * attackStrength * 0.8f);
        return new DamageFunction(modifier, function);
    }

    public static Optional<DamageFunction> createShieldFunction(LivingEntity entity, DamageSource source, float amount) {
        if (entity.isBlocking() && (double)amount > 0.0 && ((LivingEntityAccessor)entity).invoker$isDamageSourceBlocked(source)) {
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), entity, ((org.spongepowered.api.item.inventory.ItemStack)entity.getUseItem()).createSnapshot())).type(DamageModifierTypes.SHIELD).build();
            return Optional.of(new DamageFunction(modifier, damage -> -damage));
        }
        return Optional.empty();
    }
}

