/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.type.WallConnectionState;
import org.spongepowered.api.util.Direction;

public final class DirectionalUtil {
    public static Set<Direction> getHorizontalFrom(BlockState holder, BooleanProperty east, BooleanProperty west, BooleanProperty north, BooleanProperty south) {
        ImmutableMap sides = ImmutableMap.of((Object)Direction.EAST, (Object)east, (Object)Direction.WEST, (Object)west, (Object)Direction.NORTH, (Object)north, (Object)Direction.SOUTH, (Object)south);
        return DirectionalUtil.getFrom(holder, (Map<Direction, BooleanProperty>)sides);
    }

    public static Set<Direction> getHorizontalUpFrom(BlockState holder, BooleanProperty east, BooleanProperty west, BooleanProperty north, BooleanProperty south, BooleanProperty up) {
        ImmutableMap sides = ImmutableMap.builder().put((Object)Direction.EAST, (Object)east).put((Object)Direction.WEST, (Object)west).put((Object)Direction.NORTH, (Object)north).put((Object)Direction.SOUTH, (Object)south).put((Object)Direction.UP, (Object)up).build();
        return DirectionalUtil.getFrom(holder, (Map<Direction, BooleanProperty>)sides);
    }

    public static Map<Direction, WallConnectionState> getHorizontalFrom(BlockState holder, EnumProperty<WallSide> east, EnumProperty<WallSide> west, EnumProperty<WallSide> north, EnumProperty<WallSide> south) {
        ImmutableMap sides = ImmutableMap.builder().put((Object)Direction.EAST, east).put((Object)Direction.WEST, west).put((Object)Direction.NORTH, north).put((Object)Direction.SOUTH, south).build();
        HashMap<Direction, WallConnectionState> wallConnectionStates = new HashMap<Direction, WallConnectionState>();
        for (Map.Entry entry : sides.entrySet()) {
            WallConnectionState wallConnectionState = (WallConnectionState)holder.getValue((Property)entry.getValue());
            wallConnectionStates.put((Direction)entry.getKey(), wallConnectionState);
        }
        return wallConnectionStates;
    }

    public static Set<Direction> getHorizontalUpFrom(BlockState holder, EnumProperty<WallSide> east, EnumProperty<WallSide> west, EnumProperty<WallSide> north, EnumProperty<WallSide> south, BooleanProperty up) {
        ImmutableMap sides = ImmutableMap.builder().put((Object)Direction.EAST, east).put((Object)Direction.WEST, west).put((Object)Direction.NORTH, north).put((Object)Direction.SOUTH, south).build();
        HashSet<Direction> directions = new HashSet<Direction>();
        if (((Boolean)holder.getValue((Property)up)).booleanValue()) {
            directions.add(Direction.UP);
        }
        for (Map.Entry entry : sides.entrySet()) {
            if (holder.getValue((Property)entry.getValue()) == WallSide.NONE) continue;
            directions.add((Direction)entry.getKey());
        }
        return directions;
    }

    public static Set<Direction> getHorizontalUpDownFrom(BlockState holder, BooleanProperty east, BooleanProperty west, BooleanProperty north, BooleanProperty south, BooleanProperty up, BooleanProperty down) {
        ImmutableMap sides = ImmutableMap.builder().put((Object)Direction.EAST, (Object)east).put((Object)Direction.WEST, (Object)west).put((Object)Direction.NORTH, (Object)north).put((Object)Direction.SOUTH, (Object)south).put((Object)Direction.UP, (Object)up).put((Object)Direction.DOWN, (Object)down).build();
        return DirectionalUtil.getFrom(holder, (Map<Direction, BooleanProperty>)sides);
    }

    public static Set<Direction> getFrom(BlockState holder, Map<Direction, BooleanProperty> sides) {
        HashSet<Direction> directions = new HashSet<Direction>();
        for (Map.Entry<Direction, BooleanProperty> entry : sides.entrySet()) {
            if (!((Boolean)holder.getValue((Property)entry.getValue())).booleanValue()) continue;
            directions.add(entry.getKey());
        }
        return directions;
    }

    public static BlockState setHorizontal(BlockState holder, Set<Direction> value, BooleanProperty east, BooleanProperty west, BooleanProperty north, BooleanProperty south) {
        ImmutableMap sides = ImmutableMap.builder().put((Object)Direction.EAST, (Object)east).put((Object)Direction.WEST, (Object)west).put((Object)Direction.NORTH, (Object)north).put((Object)Direction.SOUTH, (Object)south).build();
        return DirectionalUtil.set(holder, value, (Map<Direction, BooleanProperty>)sides);
    }

    public static BlockState setHorizontalFor(BlockState holder, Map<Direction, WallConnectionState> value, EnumProperty<WallSide> east, EnumProperty<WallSide> west, EnumProperty<WallSide> north, EnumProperty<WallSide> south) {
        ImmutableMap sides = ImmutableMap.builder().put((Object)Direction.EAST, east).put((Object)Direction.WEST, west).put((Object)Direction.NORTH, north).put((Object)Direction.SOUTH, south).build();
        for (Map.Entry entry : sides.entrySet()) {
            @Nullable WallConnectionState wallConnectionState = value.get(entry.getKey());
            EnumProperty property = (EnumProperty)entry.getValue();
            if (wallConnectionState == null) continue;
            holder = (BlockState)holder.setValue((Property)property, (Comparable)((WallSide)wallConnectionState));
        }
        return holder;
    }

    public static BlockState setHorizontalUpFor(BlockState holder, Set<Direction> value, BooleanProperty east, BooleanProperty west, BooleanProperty north, BooleanProperty south, BooleanProperty up) {
        ImmutableMap sides = ImmutableMap.builder().put((Object)Direction.EAST, (Object)east).put((Object)Direction.WEST, (Object)west).put((Object)Direction.NORTH, (Object)north).put((Object)Direction.SOUTH, (Object)south).put((Object)Direction.UP, (Object)up).build();
        return DirectionalUtil.set(holder, value, (Map<Direction, BooleanProperty>)sides);
    }

    public static BlockState setHorizontalUpFor(BlockState holder, Set<Direction> value, EnumProperty<WallSide> east, EnumProperty<WallSide> west, EnumProperty<WallSide> north, EnumProperty<WallSide> south, BooleanProperty up) {
        ImmutableMap sides = ImmutableMap.builder().put((Object)Direction.EAST, east).put((Object)Direction.WEST, west).put((Object)Direction.NORTH, north).put((Object)Direction.SOUTH, south).build();
        for (Map.Entry entry : sides.entrySet()) {
            holder = (BlockState)holder.setValue((Property)entry.getValue(), (Comparable)(value.contains(entry.getKey()) ? WallSide.TALL : WallSide.NONE));
        }
        holder.setValue((Property)up, (Comparable)Boolean.valueOf(value.contains(Direction.UP)));
        return holder;
    }

    public static BlockState setHorizontalUpDownFor(BlockState holder, Set<Direction> value, BooleanProperty east, BooleanProperty west, BooleanProperty north, BooleanProperty south, BooleanProperty up, BooleanProperty down) {
        ImmutableMap sides = ImmutableMap.builder().put((Object)Direction.EAST, (Object)east).put((Object)Direction.WEST, (Object)west).put((Object)Direction.NORTH, (Object)north).put((Object)Direction.SOUTH, (Object)south).put((Object)Direction.UP, (Object)up).put((Object)Direction.DOWN, (Object)down).build();
        return DirectionalUtil.set(holder, value, (Map<Direction, BooleanProperty>)sides);
    }

    public static BlockState set(BlockState holder, Set<Direction> value, Map<Direction, BooleanProperty> sides) {
        for (Map.Entry<Direction, BooleanProperty> entry : sides.entrySet()) {
            holder = (BlockState)holder.setValue((Property)entry.getValue(), (Comparable)Boolean.valueOf(value.contains(entry.getKey())));
        }
        return holder;
    }

    private DirectionalUtil() {
    }
}

