/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.common.accessor.world.entity.projectile.FireworkRocketEntityAccessor;
import org.spongepowered.common.item.SpongeItemStack;
import org.spongepowered.common.util.Preconditions;

public final class FireworkUtil {
    public static boolean setFireworkEffects(Object object, List<? extends FireworkEffect> effects) {
        if (effects.isEmpty()) {
            return FireworkUtil.removeFireworkEffects(object);
        }
        ItemStack item = FireworkUtil.getItem(object);
        if (item.isEmpty()) {
            return false;
        }
        if (item.getItem() == Items.FIREWORK_STAR) {
            item.set(DataComponents.FIREWORK_EXPLOSION, (Object)((FireworkExplosion)effects.get(0)));
            return true;
        }
        if (item.getItem() == Items.FIREWORK_ROCKET) {
            List<FireworkExplosion> mcEffects = effects.stream().map(FireworkExplosion.class::cast).toList();
            item.update(DataComponents.FIREWORKS, (Object)new Fireworks(1, Collections.emptyList()), p -> new Fireworks(p.flightDuration(), mcEffects));
            return true;
        }
        return false;
    }

    public static Optional<List<FireworkEffect>> getFireworkEffects(Object object) {
        ItemStack item = FireworkUtil.getItem(object);
        if (item.isEmpty()) {
            return Optional.empty();
        }
        if (item.getItem() == Items.FIREWORK_ROCKET) {
            Fireworks fireworks = (Fireworks)item.get(DataComponents.FIREWORKS);
            if (fireworks == null || fireworks.explosions().isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(fireworks.explosions().stream().map(FireworkEffect.class::cast).toList());
        }
        Preconditions.checkArgument(item.getItem() == Items.FIREWORK_STAR, "Item is not a firework star!");
        FireworkExplosion fireworkExplosion = (FireworkExplosion)item.get(DataComponents.FIREWORK_EXPLOSION);
        if (fireworkExplosion == null) {
            return Optional.empty();
        }
        return Optional.of(List.of((FireworkEffect)fireworkExplosion));
    }

    public static boolean removeFireworkEffects(Object object) {
        ItemStack item = FireworkUtil.getItem(object);
        if (item.isEmpty()) {
            return false;
        }
        if (item.getItem() == Items.FIREWORK_STAR) {
            item.remove(DataComponents.FIREWORK_EXPLOSION);
            return true;
        }
        if (item.getItem() == Items.FIREWORK_ROCKET) {
            if (item.has(DataComponents.FIREWORKS)) {
                item.update(DataComponents.FIREWORKS, null, p -> new Fireworks(p.flightDuration(), Collections.emptyList()));
            }
            return true;
        }
        return false;
    }

    public static ItemStack getItem(FireworkRocketEntity firework) {
        ItemStack item = (ItemStack)firework.getEntityData().get(FireworkRocketEntityAccessor.accessor$DATA_ID_FIREWORKS_ITEM());
        if (item.isEmpty()) {
            item = (ItemStack)new SpongeItemStack.BuilderImpl().itemType(ItemTypes.FIREWORK_ROCKET).build();
            firework.getEntityData().set(FireworkRocketEntityAccessor.accessor$DATA_ID_FIREWORKS_ITEM(), (Object)item);
        }
        return item;
    }

    private static ItemStack getItem(Object object) {
        if (object instanceof ItemStack) {
            return (ItemStack)object;
        }
        if (object instanceof FireworkRocketEntity) {
            return FireworkUtil.getItem((FireworkRocketEntity)object);
        }
        return ItemStack.EMPTY;
    }

    private FireworkUtil() {
    }
}

