/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Color;
import org.spongepowered.math.vector.Vector3d;

public final class ParticleOptionUtil {
    public static ImmutableMap<ParticleOption<?>, Object> generateDefaultsForNamed(ParticleType<?> type) {
        HashMap<ParticleOption<Double>, Object> options = new HashMap<ParticleOption<Double>, Object>();
        options.put(ParticleOptions.OFFSET.get(), Vector3d.ZERO);
        options.put(ParticleOptions.QUANTITY.get(), 1);
        if (type == ParticleTypes.BLOCK || type == ParticleTypes.BLOCK_MARKER || type == ParticleTypes.FALLING_DUST || type == ParticleTypes.DUST_PILLAR) {
            options.put(ParticleOptions.BLOCK_STATE.get(), BlockTypes.AIR.get().defaultState());
        } else if (type == ParticleTypes.ITEM) {
            options.put(ParticleOptions.ITEM_STACK_SNAPSHOT.get(), ItemStackSnapshot.empty());
        } else if (type == ParticleTypes.DUST) {
            options.put(ParticleOptions.COLOR.get(), Color.RED);
            options.put(ParticleOptions.SCALE.get(), 1.0);
        }
        return ImmutableMap.copyOf(options);
    }

    private ParticleOptionUtil() {
    }
}

