/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.util.SpongeAABB;
import org.spongepowered.common.world.server.SpongeServerLocation;
import org.spongepowered.math.vector.Vector2i;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class VecHelper {
    public static BlockPos toBlockPos(Vector3d vector) {
        if (vector == null) {
            return null;
        }
        return new BlockPos(vector.floorX(), vector.floorY(), vector.floorZ());
    }

    public static BlockPos toBlockPos(Vector3i vector) {
        if (vector == null) {
            return null;
        }
        return new BlockPos(vector.x(), vector.y(), vector.z());
    }

    public static BlockPos toBlockPos(ServerLocation location) {
        if (location == null) {
            return null;
        }
        return ((SpongeServerLocation)location).asBlockPos();
    }

    public static Vector3i toVector3i(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        return new Vector3i(pos.getX(), pos.getY(), pos.getZ());
    }

    public static Vector3d toVector3d(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        return new Vector3d((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
    }

    public static Vector3d toVector3d(Rotations rotation) {
        if (rotation == null) {
            return null;
        }
        return new Vector3d(rotation.getX(), rotation.getY(), rotation.getZ());
    }

    public static Vector3i toVector3i(Vec3i vector) {
        if (vector == null) {
            return null;
        }
        return new Vector3i(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Vec3i toVanillaVector3i(Vector3i vector) {
        if (vector == null) {
            return null;
        }
        return new Vec3i(vector.x(), vector.y(), vector.z());
    }

    public static Vec3 toVanillaVector3d(Vector3d vector) {
        if (vector == null) {
            return null;
        }
        return new Vec3(vector.x(), vector.y(), vector.z());
    }

    public static Vec3 toVanillaVector3d(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static Vector3i toVector3i(ChunkPos pos) {
        if (pos == null) {
            return null;
        }
        return new Vector3i(pos.x, 0, pos.z);
    }

    public static ChunkPos toChunkPos(Vector3i vector) {
        if (vector == null) {
            return null;
        }
        return new ChunkPos(vector.x(), vector.x());
    }

    public static Vector3d toVector3d(Vec3 vector) {
        if (vector == null) {
            return null;
        }
        return new Vector3d(vector.x, vector.y, vector.z);
    }

    public static Vec3i toVector3i(Vector3d vector) {
        if (vector == null) {
            return null;
        }
        return new Vec3i(vector.floorX(), vector.floorY(), vector.floorZ());
    }

    public static Rotations toRotation(Vector3d vector) {
        if (vector == null) {
            return null;
        }
        return new Rotations((float)vector.x(), (float)vector.y(), (float)vector.z());
    }

    public static boolean inBounds(int x, int y, Vector2i min, Vector2i max) {
        return x >= min.x() && x <= max.x() && y >= min.y() && y <= max.y();
    }

    public static boolean inBounds(int x, int y, int z, Vec3i min, Vec3i max) {
        return x >= min.getX() && x <= max.getX() && y >= min.getY() && y <= max.getY() && z >= min.getZ() && z <= max.getZ();
    }

    public static boolean inBounds(BlockPos pos, Vector3i min, Vector3i max) {
        return VecHelper.inBounds((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), min, max);
    }

    public static boolean inBounds(Vector3d pos, Vector3i min, Vector3i max) {
        return VecHelper.inBounds(pos.x(), pos.y(), pos.z(), min, max);
    }

    public static boolean inBounds(double x, double y, double z, Vector3i min, Vector3i max) {
        return x >= (double)min.x() && x <= (double)max.x() && y >= (double)min.y() && y <= (double)max.y() && z >= (double)min.z() && z <= (double)max.z();
    }

    public static AABB toMinecraftAABB(org.spongepowered.api.util.AABB box) {
        if (box == null) {
            return null;
        }
        Vector3d min = box.min();
        Vector3d max = box.max();
        return new AABB(min.x(), min.y(), min.z(), max.x(), max.y(), max.z());
    }

    public static org.spongepowered.api.util.AABB toSpongeAABB(AABB box) {
        if (box == null) {
            return null;
        }
        return new SpongeAABB(new Vector3d(box.minX, box.minY, box.minZ), new Vector3d(box.maxX, box.maxY, box.maxZ));
    }

    public static CompoundTag toCompound(Vector3d vector) {
        CompoundTag compound = new CompoundTag();
        compound.putDouble("x", vector.x());
        compound.putDouble("y", vector.y());
        compound.putDouble("z", vector.z());
        return compound;
    }

    public static Vector3d fromCompound(CompoundTag compound) {
        return new Vector3d(compound.getDouble("x"), compound.getDouble("y"), compound.getDouble("z"));
    }

    private VecHelper() {
    }
}

