/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.raytrace;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.util.blockray.RayTrace;
import org.spongepowered.api.util.blockray.RayTraceResult;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public abstract class AbstractSpongeRayTrace<T extends Locatable>
implements RayTrace<T> {
    private final Predicate<T> defaultFilter;
    int limit = 30;
    @Nullable Vector3d start;
    @Nullable Vector3d direction;
    @Nullable Vector3d end;
    @Nullable ResourceKey world;
    @Nullable Predicate<T> select;
    @Nullable Predicate<LocatableBlock> continueWhileBlock = null;
    @Nullable Predicate<Entity> continueWhileEntity = null;
    @Nullable Predicate<ServerLocation> continueWhileLocation = null;

    AbstractSpongeRayTrace(Predicate<T> defaultFilter) {
        this.defaultFilter = defaultFilter;
        this.select = defaultFilter;
    }

    @Override
    public final @NonNull RayTrace<@NonNull T> world(@NonNull ServerWorld serverWorld) {
        this.world = serverWorld.key();
        return this;
    }

    @Override
    public @NonNull RayTrace<@NonNull T> sourceEyePosition(@NonNull Living entity) {
        this.sourcePosition((Vector3d)entity.get(Keys.EYE_POSITION).orElseThrow(() -> new IllegalArgumentException("Entity does not have an eye position key")));
        return this.world((ServerWorld)entity.serverLocation().world());
    }

    @Override
    public final @NonNull RayTrace<@NonNull T> sourcePosition(@NonNull Vector3d sourcePosition) {
        this.start = sourcePosition;
        return this;
    }

    @Override
    public @NonNull RayTrace<@NonNull T> direction(@NonNull Vector3d direction) {
        this.end = null;
        this.direction = direction.normalize();
        return this;
    }

    @Override
    public @NonNull RayTrace<@NonNull T> limit(int distance) {
        if (distance < 1) {
            throw new IllegalArgumentException("distance limit must be positive");
        }
        this.limit = distance;
        return this;
    }

    @Override
    public final @NonNull RayTrace<@NonNull T> continueUntil(@NonNull Vector3d endPosition) {
        this.end = endPosition;
        this.direction = null;
        return this;
    }

    @Override
    public @NonNull RayTrace<@NonNull T> continueWhileLocation(@NonNull Predicate<ServerLocation> continueWhileLocation) {
        this.continueWhileLocation = this.continueWhileLocation == null ? continueWhileLocation : this.continueWhileLocation.and(continueWhileLocation);
        return this;
    }

    @Override
    public @NonNull RayTrace<@NonNull T> continueWhileBlock(@NonNull Predicate<LocatableBlock> continueWhileBlock) {
        this.continueWhileBlock = this.continueWhileBlock == null ? continueWhileBlock : this.continueWhileBlock.and(continueWhileBlock);
        return this;
    }

    @Override
    public @NonNull RayTrace<@NonNull T> continueWhileEntity(@NonNull Predicate<Entity> continueWhileEntity) {
        this.continueWhileEntity = this.continueWhileEntity == null ? continueWhileEntity : this.continueWhileEntity.and(continueWhileEntity);
        return this;
    }

    @Override
    public final @NonNull RayTrace<@NonNull T> select(@NonNull Predicate<T> filter) {
        this.select = this.select == this.defaultFilter ? filter : this.select.or(filter);
        return this;
    }

    @Override
    public @NonNull Optional<RayTraceResult<@NonNull T>> execute() {
        this.setupEnd();
        Vector3d directionWithLength = this.end.sub(this.start);
        double length = directionWithLength.length();
        Vector3d direction = directionWithLength.normalize();
        if (direction.lengthSquared() == 0.0) {
            throw new IllegalStateException("The start and end must be two different vectors");
        }
        ServerWorld serverWorld = Sponge.server().worldManager().world(this.world).orElseThrow(() -> new IllegalStateException("World with key " + this.world.formatted() + " is not loaded!"));
        Vector3i currentBlock = this.initialBlock(direction);
        Vector3i steps = this.createSteps(direction);
        TData tData = this.createInitialTData(direction);
        Vector3d currentLocation = new Vector3d(this.start.x(), this.start.y(), this.start.z());
        boolean requiresEntityTracking = this.requiresEntityTracking();
        boolean requireAdvancement = true;
        while (requireAdvancement) {
            Vec3 vec3dend;
            Vector3d nextLocation;
            Vec3 vec3dstart = VecHelper.toVanillaVector3d(currentLocation);
            if (this.continueWhileLocation != null && !this.continueWhileLocation.test(ServerLocation.of(serverWorld, currentBlock))) {
                return Optional.empty();
            }
            if (tData.getTotalTWithNextStep() > length) {
                requireAdvancement = false;
                nextLocation = this.end;
                vec3dend = VecHelper.toVanillaVector3d(this.end);
            } else {
                nextLocation = currentLocation.add(direction.x() * tData.getNextStep(), direction.y() * tData.getNextStep(), direction.z() * tData.getNextStep());
                vec3dend = VecHelper.toVanillaVector3d(nextLocation);
            }
            Optional<RayTraceResult<@NonNull T>> result = this.testSelectLocation(serverWorld, vec3dstart, vec3dend);
            if (result.isPresent() && !this.shouldCheckFailures()) {
                return result;
            }
            if (!this.shouldAdvanceThroughBlock(serverWorld, vec3dstart, vec3dend)) {
                return Optional.empty();
            }
            if (requiresEntityTracking && this.continueWhileEntity != null) {
                double resultDistance = result.isPresent() ? result.get().hitPosition().distanceSquared(currentLocation) : Double.MAX_VALUE;
                AABB targetAABB = this.getBlockAABB(currentBlock);
                for (net.minecraft.world.entity.Entity entity : this.getFailingEntities(serverWorld, targetAABB)) {
                    Vec3 hitPosition;
                    double sqdist;
                    Optional vec3d = entity.getBoundingBox().clip(vec3dstart, vec3dend);
                    if (!vec3d.isPresent() || !((sqdist = (hitPosition = (Vec3)vec3d.get()).distanceToSqr(vec3dstart)) < resultDistance)) continue;
                    return Optional.empty();
                }
            }
            if (result.isPresent()) {
                return result;
            }
            if (!requireAdvancement) continue;
            currentLocation = nextLocation;
            currentBlock = this.getNextBlock(currentBlock, tData, steps);
            tData = this.advance(tData, steps, direction);
        }
        return Optional.empty();
    }

    @Override
    public @NonNull RayTrace<@NonNull T> reset() {
        this.select = this.defaultFilter;
        this.world = null;
        this.start = null;
        this.end = null;
        this.continueWhileBlock = null;
        this.continueWhileEntity = null;
        this.continueWhileLocation = null;
        return this;
    }

    final Vector3i getNextBlock(Vector3i current, TData data, Vector3i steps) {
        return current.add(data.nextStepWillAdvanceX() ? steps.x() : 0, data.nextStepWillAdvanceY() ? steps.y() : 0, data.nextStepWillAdvanceZ() ? steps.x() : 0);
    }

    final Vector3i createSteps(Vector3d direction) {
        return new Vector3i(Math.signum(direction.x()), Math.signum(direction.y()), Math.signum(direction.z()));
    }

    final AABB getBlockAABB(Vector3i currentBlock) {
        return new AABB((double)currentBlock.x(), (double)currentBlock.y(), (double)currentBlock.z(), (double)(currentBlock.x() + 1), (double)(currentBlock.y() + 1), (double)(currentBlock.z() + 1));
    }

    private List<net.minecraft.world.entity.Entity> getFailingEntities(ServerWorld serverWorld, AABB targetAABB) {
        return ((Level)serverWorld).getEntities((net.minecraft.world.entity.Entity)null, targetAABB, this.continueWhileEntity.negate());
    }

    boolean requiresEntityTracking() {
        return this.continueWhileEntity != null;
    }

    List<net.minecraft.world.entity.Entity> selectEntities(ServerWorld serverWorld, AABB targetAABB) {
        return Collections.emptyList();
    }

    abstract Optional<RayTraceResult<@NonNull T>> testSelectLocation(ServerWorld var1, Vec3 var2, Vec3 var3);

    final LocatableBlock getBlock(ServerWorld world, Vec3 in, Vec3 out) {
        Vector3i coord = new Vector3i(Math.min(in.x, out.x), Math.min(in.y, out.y), Math.min(in.z, out.z));
        return world.locatableBlock(coord);
    }

    private boolean shouldAdvanceThroughBlock(ServerWorld serverWorld, Vec3 location, Vec3 exitLocation) {
        if (this.continueWhileBlock == null) {
            return true;
        }
        return this.continueWhileBlock.test(this.getBlock(serverWorld, location, exitLocation));
    }

    boolean shouldCheckFailures() {
        return false;
    }

    final void setupEnd() {
        if (this.start == null) {
            throw new IllegalStateException("start cannot be null");
        }
        if (this.end == null && this.direction == null) {
            throw new IllegalStateException("end or direction needs to be specified");
        }
        if (this.world == null) {
            throw new IllegalStateException("world cannot be null");
        }
        if (this.select == null) {
            throw new IllegalStateException("select filter cannot be null");
        }
        if (this.direction != null) {
            this.continueUntil(this.start.add(this.direction.mul((float)this.limit)));
        }
    }

    final Vector3i initialBlock(Vector3d direction) {
        return new Vector3i(this.start.x() - (double)(direction.x() < 0.0 && this.start.x() == 0.0 ? 1 : 0), this.start.y() - (double)(direction.y() < 0.0 && this.start.y() == 0.0 ? 1 : 0), this.start.z() - (double)(direction.z() < 0.0 && this.start.z() == 0.0 ? 1 : 0));
    }

    final TData createInitialTData(Vector3d direction) {
        return new TData(0.0, this.getT(this.start.x(), direction.x(), this.end.x()), this.getT(this.start.y(), direction.y(), this.end.y()), this.getT(this.start.z(), direction.z(), this.end.z()));
    }

    final TData advance(TData data, Vector3i steps, Vector3d direction) {
        double nextStep = data.getNextStep();
        return new TData(data.getTotalTWithNextStep(), data.nextStepWillAdvanceX() ? (double)steps.x() / direction.x() : data.gettToX() - nextStep, data.nextStepWillAdvanceY() ? (double)steps.y() / direction.y() : data.gettToY() - nextStep, data.nextStepWillAdvanceZ() ? (double)steps.z() / direction.z() : data.gettToZ() - nextStep);
    }

    private double getT(double start, double direction, double end) {
        if (direction > 0.0) {
            return (Math.min(end, Math.ceil(start)) - start) / direction;
        }
        if (direction < 0.0) {
            return (Math.max(end, Math.floor(start)) - start) / direction;
        }
        return Double.POSITIVE_INFINITY;
    }

    static final class TData {
        private final double totalT;
        private final double tToX;
        private final double tToY;
        private final double tToZ;
        private final double nextStep;

        TData(double totalT, double tToX, double tToY, double tToZ) {
            this.totalT = totalT;
            this.tToX = tToX;
            this.tToY = tToY;
            this.tToZ = tToZ;
            this.nextStep = Math.min(tToX, Math.min(tToY, tToZ));
        }

        public double getTotalT() {
            return this.totalT;
        }

        public double gettToX() {
            return this.tToX;
        }

        public double gettToY() {
            return this.tToY;
        }

        public double gettToZ() {
            return this.tToZ;
        }

        public boolean nextStepWillAdvanceX() {
            return this.tToX <= this.nextStep;
        }

        public boolean nextStepWillAdvanceY() {
            return this.tToY <= this.nextStep;
        }

        public boolean nextStepWillAdvanceZ() {
            return this.tToZ <= this.nextStep;
        }

        public double getNextStep() {
            return this.nextStep;
        }

        public double getTotalTWithNextStep() {
            return this.nextStep + this.totalT;
        }
    }
}

