/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config.flat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.generation.config.flat.FlatGeneratorConfig;
import org.spongepowered.api.world.generation.config.flat.LayerConfig;
import org.spongepowered.api.world.generation.structure.StructureSet;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.level.levelgen.flat.FlatLevelGeneratorSettingsAccessor;

public final class SpongeFlatGeneratorConfig {

    public static final class BuilderImpl
    implements FlatGeneratorConfig.Builder {
        public final List<LayerConfig> layers = new ArrayList<LayerConfig>();
        public @Nullable RegistryReference<org.spongepowered.api.world.biome.Biome> biome;
        public boolean performDecoration;
        public boolean populateLakes;
        private @Nullable List<StructureSet> structureSets;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public FlatGeneratorConfig.Builder addLayer(int index, LayerConfig config) {
            this.layers.add(index, Objects.requireNonNull(config, "config"));
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder addLayer(LayerConfig config) {
            this.layers.add(Objects.requireNonNull(config, "config"));
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder addLayers(List<LayerConfig> layers) {
            this.layers.addAll((Collection<LayerConfig>)Objects.requireNonNull(layers, "layers"));
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder removeLayer(int index) {
            this.layers.remove(index);
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder biome(RegistryReference<org.spongepowered.api.world.biome.Biome> biome) {
            this.biome = Objects.requireNonNull(biome, "biome");
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder performDecoration(boolean performDecoration) {
            this.performDecoration = performDecoration;
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder populateLakes(boolean populateLakes) {
            this.populateLakes = populateLakes;
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder structureSets(@Nullable List<StructureSet> structureSets) {
            this.structureSets = structureSets;
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder reset() {
            this.biome = null;
            this.layers.clear();
            this.performDecoration = false;
            this.populateLakes = true;
            this.structureSets = null;
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder from(FlatGeneratorConfig value) {
            this.layers.addAll(value.layers());
            this.performDecoration = value.performDecoration();
            this.populateLakes = value.populateLakes();
            this.structureSets = value.structureSets().orElse(null);
            return this;
        }

        public @NonNull FlatGeneratorConfig build() {
            if (this.biome == null) {
                throw new IllegalStateException("Flat generation requires a biome to be specified!");
            }
            if (this.layers.isEmpty()) {
                throw new IllegalStateException("Flat generation requires at least 1 Layer!");
            }
            Registry biomeRegistry = SpongeCommon.vanillaRegistry(Registries.BIOME);
            HolderLookup.RegistryLookup placedFeatureRegistryLookup = SpongeCommon.vanillaRegistry(Registries.PLACED_FEATURE).asLookup();
            Optional defaultStructures = FlatLevelGeneratorSettings.getDefault((HolderGetter)biomeRegistry.asLookup(), (HolderGetter)SpongeCommon.vanillaRegistry(Registries.STRUCTURE_SET).asLookup(), (HolderGetter)placedFeatureRegistryLookup).structureOverrides();
            Holder.Reference biome = biomeRegistry.asLookup().getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)((ResourceLocation)this.biome.location())));
            return (FlatGeneratorConfig)FlatLevelGeneratorSettingsAccessor.invoker$new(defaultStructures, this.layers, this.populateLakes, this.performDecoration, Optional.of(biome), (Holder.Reference<Biome>)biome, (Holder<PlacedFeature>)placedFeatureRegistryLookup.getOrThrow(MiscOverworldPlacements.LAKE_LAVA_UNDERGROUND), (Holder<PlacedFeature>)placedFeatureRegistryLookup.getOrThrow(MiscOverworldPlacements.LAKE_LAVA_SURFACE));
        }
    }
}

