/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config.noise;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.biome.BiomeAttributes;
import org.spongepowered.api.world.generation.config.SurfaceRule;
import org.spongepowered.api.world.generation.config.noise.NoiseConfig;
import org.spongepowered.api.world.generation.config.noise.NoiseConfigs;
import org.spongepowered.api.world.generation.config.noise.NoiseGeneratorConfig;
import org.spongepowered.api.world.generation.config.noise.NoiseGeneratorConfigTemplate;
import org.spongepowered.api.world.generation.config.noise.NoiseGeneratorConfigs;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeNoiseGeneratorConfigTemplate
extends Record
implements NoiseGeneratorConfigTemplate {
    private final ResourceKey key;
    private final NoiseGeneratorSettings representedSettings;
    private final DataPack<NoiseGeneratorConfigTemplate> pack;

    public SpongeNoiseGeneratorConfigTemplate(ResourceKey key, NoiseGeneratorSettings representedSettings, DataPack<NoiseGeneratorConfigTemplate> pack) {
        this.key = key;
        this.representedSettings = representedSettings;
        this.pack = pack;
    }

    @Override
    public NoiseGeneratorConfig config() {
        return (NoiseGeneratorConfig)this.representedSettings;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement serialized = SpongeNoiseGeneratorConfigTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            return DataFormats.JSON.get().read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized NoiseGeneratorConfig:\n" + String.valueOf(serialized), e);
        }
    }

    public static JsonElement encode(NoiseGeneratorConfigTemplate template, RegistryAccess registryAccess) {
        return (JsonElement)NoiseGeneratorSettings.DIRECT_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((NoiseGeneratorSettings)template.config())).getOrThrow();
    }

    public static NoiseGeneratorSettings decode(JsonElement json, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        return (NoiseGeneratorSettings)NoiseGeneratorSettings.DIRECT_CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow();
    }

    public static NoiseGeneratorConfigTemplate decode(DataPack<NoiseGeneratorConfigTemplate> pack, ResourceKey key, JsonElement packEntry, RegistryAccess registryAccess) {
        NoiseGeneratorSettings parsed = SpongeNoiseGeneratorConfigTemplate.decode(packEntry, registryAccess);
        return new SpongeNoiseGeneratorConfigTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeNoiseGeneratorConfigTemplate.class, "key;representedSettings;pack", "key", "representedSettings", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeNoiseGeneratorConfigTemplate.class, "key;representedSettings;pack", "key", "representedSettings", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeNoiseGeneratorConfigTemplate.class, "key;representedSettings;pack", "key", "representedSettings", "pack"}, this, o);
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public NoiseGeneratorSettings representedSettings() {
        return this.representedSettings;
    }

    @Override
    public DataPack<NoiseGeneratorConfigTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<NoiseGeneratorConfig, NoiseGeneratorConfigTemplate, NoiseGeneratorConfigTemplate.Builder>
    implements NoiseGeneratorConfigTemplate.Builder {
        public NoiseConfig noiseConfig;
        public BlockState defaultBlock;
        public BlockState defaultFluid;
        public int seaLevel;
        public boolean aquifers;
        public boolean oreVeins;
        public boolean legacyRandomSource;
        public boolean disableMobGeneration;
        public SurfaceRule surfaceRule;
        private org.spongepowered.api.world.generation.config.noise.NoiseRouter router;
        private List<BiomeAttributes> spawnTargets;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public Function<NoiseGeneratorConfigTemplate, NoiseGeneratorConfig> valueExtractor() {
            return NoiseGeneratorConfigTemplate::config;
        }

        @Override
        public NoiseGeneratorConfigTemplate.Builder noiseConfig(NoiseConfig config) {
            this.noiseConfig = Objects.requireNonNull(config, "config");
            return this;
        }

        @Override
        public NoiseGeneratorConfigTemplate.Builder defaultBlock(BlockState block) {
            this.defaultBlock = Objects.requireNonNull(block, "block");
            return this;
        }

        @Override
        public NoiseGeneratorConfigTemplate.Builder defaultFluid(BlockState fluid) {
            this.defaultFluid = Objects.requireNonNull(fluid, "fluid");
            return this;
        }

        @Override
        public NoiseGeneratorConfigTemplate.Builder surfaceRule(SurfaceRule rule) {
            this.surfaceRule = rule;
            return this;
        }

        @Override
        public NoiseGeneratorConfigTemplate.Builder seaLevel(int y) {
            this.seaLevel = y;
            return this;
        }

        @Override
        public NoiseGeneratorConfigTemplate.Builder mobGeneration(boolean mobGeneration) {
            this.disableMobGeneration = !mobGeneration;
            return this;
        }

        @Override
        public NoiseGeneratorConfigTemplate.Builder aquifers(boolean enableAquifers) {
            this.aquifers = enableAquifers;
            return this;
        }

        @Override
        public NoiseGeneratorConfigTemplate.Builder oreVeins(boolean enableOreVeins) {
            this.oreVeins = enableOreVeins;
            return this;
        }

        @Override
        public NoiseGeneratorConfigTemplate.Builder randomSource(boolean useLegacyRandomSource) {
            this.legacyRandomSource = useLegacyRandomSource;
            return this;
        }

        @Override
        public NoiseGeneratorConfigTemplate.Builder noiseRouter(org.spongepowered.api.world.generation.config.noise.NoiseRouter router) {
            this.router = router;
            return this;
        }

        @Override
        public NoiseGeneratorConfigTemplate.Builder spawnTargets(List<BiomeAttributes> spawnTargets) {
            this.spawnTargets = spawnTargets;
            return this;
        }

        @Override
        public NoiseGeneratorConfigTemplate.Builder reset() {
            this.noiseConfig = NoiseConfigs.OVERWORLD.get();
            this.defaultBlock = (BlockState)BlockTypes.STONE.get().defaultState();
            this.defaultFluid = (BlockState)BlockTypes.WATER.get().defaultState();
            this.surfaceRule = SurfaceRule.overworld();
            this.seaLevel = 63;
            this.aquifers = false;
            this.oreVeins = false;
            this.legacyRandomSource = false;
            this.router = NoiseGeneratorConfigs.OVERWORLD.get().noiseRouter();
            this.spawnTargets = new OverworldBiomeBuilder().spawnTarget();
            this.pack = DataPacks.NOISE_GENERATOR_CONFIG;
            this.key = null;
            return this;
        }

        @Override
        public NoiseGeneratorConfigTemplate.Builder fromValue(NoiseGeneratorConfig value) {
            this.noiseConfig = value.noiseConfig();
            this.defaultBlock = value.defaultBlock();
            this.defaultFluid = value.defaultFluid();
            this.surfaceRule = value.surfaceRule();
            this.seaLevel = value.seaLevel();
            this.aquifers = value.aquifers();
            this.legacyRandomSource = value.legacyRandomSource();
            return this;
        }

        @Override
        public NoiseGeneratorConfigTemplate.Builder fromDataPack(DataView datapack) throws IOException {
            JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(datapack));
            NoiseGeneratorSettings decoded = SpongeNoiseGeneratorConfigTemplate.decode(json, (RegistryAccess)SpongeCommon.server().registryAccess());
            return this.fromValue((NoiseGeneratorConfig)decoded);
        }

        @Override
        protected NoiseGeneratorConfigTemplate build0() {
            NoiseGeneratorSettings settings = new NoiseGeneratorSettings((NoiseSettings)this.noiseConfig, (net.minecraft.world.level.block.state.BlockState)this.defaultBlock, (net.minecraft.world.level.block.state.BlockState)this.defaultFluid, (NoiseRouter)this.router, (SurfaceRules.RuleSource)this.surfaceRule, this.spawnTargets, this.seaLevel, this.disableMobGeneration, this.aquifers, this.oreVeins, this.legacyRandomSource);
            return new SpongeNoiseGeneratorConfigTemplate(this.key, settings, this.pack);
        }
    }
}

