/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.generation.feature.FeatureTemplate;
import org.spongepowered.api.world.generation.feature.FeatureType;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeFeatureTemplate
extends Record
implements FeatureTemplate {
    private final ResourceKey key;
    private final ConfiguredFeature<?, ?> representedFeature;
    private final DataPack<FeatureTemplate> pack;

    public SpongeFeatureTemplate(ResourceKey key, ConfiguredFeature<?, ?> representedFeature, DataPack<FeatureTemplate> pack) {
        this.key = key;
        this.representedFeature = representedFeature;
        this.pack = pack;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement serialized = SpongeFeatureTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            return DataFormats.JSON.get().read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized Feature:\n" + String.valueOf(serialized), e);
        }
    }

    @Override
    public org.spongepowered.api.world.generation.feature.Feature feature() {
        return (org.spongepowered.api.world.generation.feature.Feature)this.representedFeature;
    }

    public static JsonElement encode(FeatureTemplate template, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        return (JsonElement)ConfiguredFeature.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)((ConfiguredFeature)template.feature())).getOrThrow();
    }

    public static ConfiguredFeature<?, ?> decode(JsonElement json, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        return (ConfiguredFeature)ConfiguredFeature.DIRECT_CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow();
    }

    public static SpongeFeatureTemplate decode(DataPack<FeatureTemplate> pack, ResourceKey key, JsonElement packEntry, RegistryAccess registryAccess) {
        ConfiguredFeature<?, ?> parsed = SpongeFeatureTemplate.decode(packEntry, registryAccess);
        return new SpongeFeatureTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeFeatureTemplate.class, "key;representedFeature;pack", "key", "representedFeature", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeFeatureTemplate.class, "key;representedFeature;pack", "key", "representedFeature", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeFeatureTemplate.class, "key;representedFeature;pack", "key", "representedFeature", "pack"}, this, o);
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public ConfiguredFeature<?, ?> representedFeature() {
        return this.representedFeature;
    }

    @Override
    public DataPack<FeatureTemplate> pack() {
        return this.pack;
    }

    public static class BuilderImpl
    extends AbstractDataPackEntryBuilder<org.spongepowered.api.world.generation.feature.Feature, FeatureTemplate, FeatureTemplate.Builder>
    implements FeatureTemplate.Builder {
        private Feature<?> type;
        private FeatureConfiguration config;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public Function<FeatureTemplate, org.spongepowered.api.world.generation.feature.Feature> valueExtractor() {
            return FeatureTemplate::feature;
        }

        @Override
        public FeatureTemplate.Builder type(FeatureType type) {
            this.type = (Feature)type;
            return this;
        }

        @Override
        public FeatureTemplate.Builder reset() {
            this.key = null;
            this.type = null;
            this.config = null;
            this.pack = DataPacks.FEATURE;
            return this;
        }

        @Override
        public FeatureTemplate.Builder fromValue(org.spongepowered.api.world.generation.feature.Feature feature) {
            this.type(feature.type());
            this.config = ((ConfiguredFeature)feature).config();
            return this;
        }

        @Override
        public FeatureTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(pack));
            ConfiguredFeature<?, ?> feature = SpongeFeatureTemplate.decode(json, (RegistryAccess)SpongeCommon.server().registryAccess());
            this.fromValue((org.spongepowered.api.world.generation.feature.Feature)feature);
            return this;
        }

        @Override
        protected FeatureTemplate build0() {
            Objects.requireNonNull(this.type, "config");
            Objects.requireNonNull(this.config, "config");
            ConfiguredFeature feature = new ConfiguredFeature(this.type, this.config);
            return new SpongeFeatureTemplate(this.key, feature, this.pack);
        }
    }
}

