/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.generation.feature.Feature;
import org.spongepowered.api.world.generation.feature.FeatureTemplate;
import org.spongepowered.api.world.generation.feature.PlacedFeatureTemplate;
import org.spongepowered.api.world.generation.feature.PlacementModifier;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongePlacedFeatureTemplate
extends Record
implements PlacedFeatureTemplate {
    private final org.spongepowered.api.ResourceKey key;
    private final PlacedFeature represented;
    private final DataPack<PlacedFeatureTemplate> pack;

    public SpongePlacedFeatureTemplate(org.spongepowered.api.ResourceKey key, PlacedFeature represented, DataPack<PlacedFeatureTemplate> pack) {
        this.key = key;
        this.represented = represented;
        this.pack = pack;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement serialized = SpongePlacedFeatureTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            DataContainer container = DataFormats.JSON.get().read(serialized.toString());
            container.set(Queries.CONTENT_VERSION, this.contentVersion());
            return container;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized Placed Feature:\n" + String.valueOf(serialized), e);
        }
    }

    @Override
    public org.spongepowered.api.world.generation.feature.PlacedFeature feature() {
        return (org.spongepowered.api.world.generation.feature.PlacedFeature)this.represented;
    }

    public static JsonElement encode(PlacedFeatureTemplate template, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        return (JsonElement)PlacedFeature.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)((PlacedFeature)template.feature())).getOrThrow();
    }

    public static PlacedFeature decode(JsonElement json, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        return (PlacedFeature)PlacedFeature.DIRECT_CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow();
    }

    public static PlacedFeatureTemplate decode(DataPack<PlacedFeatureTemplate> pack, org.spongepowered.api.ResourceKey key, JsonElement packEntry, RegistryAccess registryAccess) {
        PlacedFeature parsed = SpongePlacedFeatureTemplate.decode(packEntry, registryAccess);
        return new SpongePlacedFeatureTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongePlacedFeatureTemplate.class, "key;represented;pack", "key", "represented", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongePlacedFeatureTemplate.class, "key;represented;pack", "key", "represented", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongePlacedFeatureTemplate.class, "key;represented;pack", "key", "represented", "pack"}, this, o);
    }

    @Override
    public org.spongepowered.api.ResourceKey key() {
        return this.key;
    }

    public PlacedFeature represented() {
        return this.represented;
    }

    @Override
    public DataPack<PlacedFeatureTemplate> pack() {
        return this.pack;
    }

    public static class BuilderImpl
    extends AbstractDataPackEntryBuilder<org.spongepowered.api.world.generation.feature.PlacedFeature, PlacedFeatureTemplate, PlacedFeatureTemplate.Builder>
    implements PlacedFeatureTemplate.Builder {
        private Holder<ConfiguredFeature<?, ?>> feature;
        private List<net.minecraft.world.level.levelgen.placement.PlacementModifier> modifiers = new ArrayList<net.minecraft.world.level.levelgen.placement.PlacementModifier>();

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public Function<PlacedFeatureTemplate, org.spongepowered.api.world.generation.feature.PlacedFeature> valueExtractor() {
            return PlacedFeatureTemplate::feature;
        }

        @Override
        public PlacedFeatureTemplate.Builder reset() {
            this.key = null;
            this.feature = null;
            this.modifiers.clear();
            this.pack = DataPacks.PLACED_FEATURE;
            return this;
        }

        @Override
        public PlacedFeatureTemplate.Builder fromValue(org.spongepowered.api.world.generation.feature.PlacedFeature feature) {
            this.feature(feature.feature());
            this.modifiers.clear();
            this.modifiers.addAll(feature.placementModifiers());
            return this;
        }

        @Override
        public PlacedFeatureTemplate.Builder feature(Feature feature) {
            Registry registry = SpongeCommon.vanillaRegistry(Registries.CONFIGURED_FEATURE);
            ResourceLocation key = registry.getKey((Object)((ConfiguredFeature)feature));
            this.feature = key == null ? Holder.direct((Object)((ConfiguredFeature)feature)) : registry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)key));
            return this;
        }

        @Override
        public PlacedFeatureTemplate.Builder feature(FeatureTemplate feature) {
            Registry registry = SpongeCommon.vanillaRegistry(Registries.CONFIGURED_FEATURE);
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)((ResourceLocation)feature.key()));
            this.feature = Holder.Reference.createStandAlone((HolderOwner)registry.asLookup(), (ResourceKey)key);
            return this;
        }

        @Override
        public PlacedFeatureTemplate.Builder addModifier(PlacementModifier modifier) {
            this.modifiers.add((net.minecraft.world.level.levelgen.placement.PlacementModifier)modifier);
            return this;
        }

        @Override
        public PlacedFeatureTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(pack));
            PlacedFeature feature = SpongePlacedFeatureTemplate.decode(json, (RegistryAccess)SpongeCommon.server().registryAccess());
            this.fromValue((org.spongepowered.api.world.generation.feature.PlacedFeature)feature);
            return this;
        }

        @Override
        protected PlacedFeatureTemplate build0() {
            PlacedFeature feature = new PlacedFeature(this.feature, this.modifiers);
            return new SpongePlacedFeatureTemplate(this.key, feature, this.pack);
        }
    }
}

