/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.level.chunk.storage;

import com.google.common.collect.ImmutableList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.world.chunk.EntityChunk;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.entity.ObjectArrayMutableEntityBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeEntityChunk
implements EntityChunk {
    private final ServerLevel level;
    private final Vector3i chunkPosition;
    private final Stream<net.minecraft.world.entity.Entity> entities;
    private @MonotonicNonNull SpongeChunkLayout chunkLayout;
    private @MonotonicNonNull Vector3i blockMin;
    private @MonotonicNonNull Vector3i blockMax;
    private @MonotonicNonNull List<net.minecraft.world.entity.Entity> newEntities;

    public SpongeEntityChunk(ServerLevel level, Vector3i chunkPosition, Stream<net.minecraft.world.entity.Entity> entities) {
        this.level = level;
        this.chunkPosition = chunkPosition;
        this.entities = entities;
    }

    @Override
    public Vector3i min() {
        if (this.blockMin == null) {
            if (this.chunkLayout == null) {
                this.chunkLayout = new SpongeChunkLayout(this.level.getMinBuildHeight(), this.level.getHeight());
            }
            this.blockMin = this.chunkLayout.forceToWorld(this.chunkPosition);
        }
        return this.blockMin;
    }

    @Override
    public Vector3i max() {
        if (this.blockMax == null) {
            if (this.chunkLayout == null) {
                this.chunkLayout = new SpongeChunkLayout(this.level.getMinBuildHeight(), this.level.getHeight());
            }
            this.blockMax = this.min().add(this.chunkLayout.chunkSize()).sub(1, 1, 1);
        }
        return this.blockMax;
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    @Override
    public boolean isAreaAvailable(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    @Override
    public Collection<? extends Player> players() {
        return this.entities.filter(Player.class::isInstance).map(Player.class::cast).toList();
    }

    @Override
    public Optional<Entity> entity(UUID uuid) {
        return this.entities.filter(e -> e.getUUID().equals(uuid)).map(Entity.class::cast).findFirst();
    }

    @Override
    public Collection<? extends Entity> entities() {
        return this.entities.map(Entity.class::cast).toList();
    }

    @Override
    public <T extends Entity> Collection<? extends T> entities(Class<? extends T> entityClass, org.spongepowered.api.util.AABB box, @Nullable Predicate<? super T> predicate) {
        AABB mcAabb = VecHelper.toMinecraftAABB(box);
        return this.entities.filter(e -> entityClass.isInstance(e) && e.getBoundingBox().intersects(mcAabb)).map(entityClass::cast).filter(e -> predicate.test(e)).toList();
    }

    @Override
    public Collection<? extends Entity> entities(org.spongepowered.api.util.AABB box, Predicate<? super Entity> filter) {
        AABB mcAabb = VecHelper.toMinecraftAABB(box);
        return this.entities.map(Entity.class::cast).filter(e -> ((net.minecraft.world.entity.Entity)e).getBoundingBox().intersects(mcAabb) && filter.test((Entity)e)).toList();
    }

    @Override
    public VolumeStream<EntityChunk, Entity> entityStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        ObjectArrayMutableEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableEntityBuffer(min, size) : null;
        return VolumeStreamUtils.generateStream(options, this, this, chunk -> chunk.entities.filter(entity -> VecHelper.inBounds(entity.blockPosition(), min, max)).map(entity -> new AbstractMap.SimpleEntry<BlockPos, net.minecraft.world.entity.Entity>(entity.blockPosition(), (net.minecraft.world.entity.Entity)entity)), VolumeStreamUtils.getOrCloneEntityWithVolume(shouldCarbonCopy, backingVolume, (Level)this.level), (key, entity) -> entity.getUUID(), (entityUuid, chunk) -> {
            net.minecraft.world.entity.Entity entity;
            net.minecraft.world.entity.Entity entity2 = entity = shouldCarbonCopy ? (net.minecraft.world.entity.Entity)backingVolume.entity((UUID)entityUuid).orElse(null) : (net.minecraft.world.entity.Entity)chunk.entity((UUID)entityUuid).orElse(null);
            if (entity == null) {
                return null;
            }
            return new Tuple((Object)entity.blockPosition(), (Object)entity);
        });
    }

    @Override
    public <E extends Entity> E createEntity(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        this.checkPositionInChunk(position);
        return ((LevelBridge)this.level).bridge$createEntity(type, position, false);
    }

    @Override
    public <E extends Entity> E createEntityNaturally(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        this.checkPositionInChunk(position);
        return ((LevelBridge)this.level).bridge$createEntity(type, position, true);
    }

    @Override
    public Optional<Entity> createEntity(DataContainer container) {
        return Optional.ofNullable(((LevelBridge)this.level).bridge$createEntity(container, null, position -> VecHelper.inBounds(position, this.min(), this.max())));
    }

    @Override
    public Optional<Entity> createEntity(DataContainer container, Vector3d position) {
        this.checkPositionInChunk(position);
        return Optional.ofNullable(((LevelBridge)this.level).bridge$createEntity(container, position, null));
    }

    @Override
    public boolean spawnEntity(Entity entity) {
        if (this.newEntities == null) {
            this.newEntities = new ArrayList<net.minecraft.world.entity.Entity>();
        }
        this.newEntities.add((net.minecraft.world.entity.Entity)entity);
        return true;
    }

    @Override
    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Entity entity : entities) {
            this.spawnEntity(entity);
            list.add(entity);
        }
        return list;
    }

    private void checkPositionInChunk(Vector3d position) {
        if (!VecHelper.inBounds(position, this.min(), this.max())) {
            throw new IllegalArgumentException("Supplied bounds are not within this chunk.");
        }
    }

    public @Nullable List<net.minecraft.world.entity.Entity> buildIfChanged() {
        if (this.newEntities == null) {
            return null;
        }
        return (List)Stream.concat(this.entities, this.newEntities.stream()).collect(ImmutableList.toImmutableList());
    }
}

