/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.IdMapper;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteReference;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.common.world.schematic.MutableBimapPalette;

public class PaletteWrapper<NT, T, R>
implements Palette.Immutable<T, R> {
    private final PaletteType<T, R> type;
    private final IdMapper<NT> proxy;
    private final Registry<R> registry;

    public static <NT, T, R> PaletteWrapper<NT, T, R> of(PaletteType<T, R> type, IdMapper<NT> proxy, Registry<R> registry) {
        return new PaletteWrapper<NT, T, R>(type, proxy, registry);
    }

    private PaletteWrapper(PaletteType<T, R> type, IdMapper<NT> proxy, Registry<R> registry) {
        this.type = type;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public PaletteType<T, R> type() {
        return this.type;
    }

    @Override
    public int highestId() {
        return this.proxy.size();
    }

    @Override
    public Optional<PaletteReference<T, R>> get(int id) {
        Object n = this.proxy.byId(id);
        if (n == null) {
            return Optional.empty();
        }
        String apply = this.type.stringifier().apply(this.registry, (Registry<R>)n);
        return Optional.of(PaletteReference.byString(this.registry.type(), apply));
    }

    @Override
    public OptionalInt get(T type) {
        int id = this.proxy.getId(type);
        if (id >= 0) {
            return OptionalInt.of(id);
        }
        return OptionalInt.empty();
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(() -> this.proxy.spliterator(), 1104, false).map(n -> n);
    }

    @Override
    public Stream<Map.Entry<T, Integer>> streamWithIds() {
        return Stream.empty();
    }

    @Override
    public Palette.Mutable<T, R> asMutable(RegistryHolder registry) {
        MutableBimapPalette mutable = new MutableBimapPalette(this.type, this.registry);
        for (Object nt : this.proxy) {
            mutable.orAssign(nt);
        }
        return mutable;
    }

    @Override
    public Palette.Immutable<T, R> asImmutable() {
        return this;
    }
}

