/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.blockentity;

import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.volume.block.entity.BlockEntityVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.bridge.world.level.block.state.BlockStateBridge;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.block.AbstractBlockBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public abstract class AbstractMutableBlockEntityBuffer
extends AbstractBlockBuffer
implements BlockEntityVolume.Mutable {
    private final ArrayMutableBlockBuffer blockBuffer;

    protected AbstractMutableBlockEntityBuffer(Vector3i start, Vector3i size) {
        super(start, size);
        this.blockBuffer = new ArrayMutableBlockBuffer(start, size);
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        if (this.blockBuffer.setBlock(x, y, z, block) && ((BlockStateBridge)((Object)block)).bridge$hasTileEntity()) {
            this.removeBlockEntity(x, y, z);
        }
        return false;
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        if (this.blockBuffer.removeBlock(x, y, z)) {
            this.removeBlockEntity(x, y, z);
        }
        return false;
    }

    @Override
    public Palette<BlockState, BlockType> blockPalette() {
        return this.blockBuffer.blockPalette();
    }

    @Override
    public BlockState block(int x, int y, int z) {
        return this.blockBuffer.block(x, y, z);
    }

    @Override
    public FluidState fluid(int x, int y, int z) {
        return this.blockBuffer.fluid(x, y, z);
    }

    @Override
    public int highestYAt(int x, int z) {
        return this.blockBuffer.highestYAt(x, z);
    }

    @Override
    public VolumeStream<BlockEntityVolume.Mutable, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min, max, this.min(), this.max(), options);
        ArrayMutableBlockBuffer buffer = options.carbonCopy() ? this.blockBuffer.copy() : this.blockBuffer;
        Stream stateStream = IntStream.rangeClosed(min.x(), max.x()).mapToObj(x -> IntStream.rangeClosed(min.z(), max.z()).mapToObj(z -> IntStream.rangeClosed(min.y(), max.y()).mapToObj(y -> VolumeElement.of(this, () -> buffer.block(x, y, z), new Vector3d((float)x, (float)y, (float)z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<BlockEntityVolume.Mutable, BlockState>(stateStream, () -> this);
    }
}

