/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.stream;

import java.util.Objects;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.common.world.volume.stream.SpongeStreamOptionsBuilder;

public class SpongeStreamOptions
implements StreamOptions {
    private final boolean copies;
    private final StreamOptions.LoadingStyle loadingStyle;

    SpongeStreamOptions(SpongeStreamOptionsBuilder builder) {
        Objects.requireNonNull(builder, "Builder cannot be null!");
        this.loadingStyle = builder.loadingStyle;
        this.copies = builder.copies;
    }

    @Override
    public boolean carbonCopy() {
        return this.copies;
    }

    @Override
    public StreamOptions.LoadingStyle loadingStyle() {
        return this.loadingStyle;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeStreamOptions that = (SpongeStreamOptions)o;
        return this.copies == that.copies && this.loadingStyle == that.loadingStyle;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.copies, this.loadingStyle});
    }

    public String toString() {
        return new StringJoiner(", ", SpongeStreamOptions.class.getSimpleName() + "[", "]").add("copies=" + this.copies).add("loadingStyle=" + String.valueOf((Object)this.loadingStyle)).toString();
    }
}

