/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.applaunch.util;

import cpw.mods.modlauncher.TransformingClassLoader;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.selector.ClassLoaderContextSelector;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VanillaLoggerContextSelector
extends AsyncLoggerContextSelector {
    private static final String CONTEXT_PROVIDER_CLASS = "org.spongepowered.vanilla.chat.VanillaLoggerContextProvider";

    public LoggerContext getContext(String fqcn, @Nullable ClassLoader loader, boolean currentContext, URI configLocation) {
        if (!currentContext && loader instanceof TransformingClassLoader) {
            return this.provideTransformingContext(loader, configLocation);
        }
        if (loader == null) {
            Class clazz = StackLocatorUtil.getCallerClass((String)fqcn);
            if (clazz != null && clazz.getClassLoader() instanceof TransformingClassLoader) {
                return this.provideTransformingContext(clazz.getClassLoader(), configLocation);
            }
            LoggerContext lc = (LoggerContext)ContextAnchor.THREAD_CONTEXT.get();
            if (lc != null) {
                return lc;
            }
            return this.getDefault();
        }
        return super.getContext(fqcn, loader, currentContext, configLocation);
    }

    protected LoggerContext provideTransformingContext(ClassLoader loader, URI configLocation) {
        String name = this.toContextMapKey(loader);
        AtomicReference ref = (AtomicReference)ClassLoaderContextSelector.CONTEXT_MAP.get(name);
        if (ref == null) {
            LoggerContext ctx = this.createSpongeContext(loader, name, configLocation);
            AtomicReference<WeakReference<LoggerContext>> r = new AtomicReference<WeakReference<LoggerContext>>();
            r.set(new WeakReference<LoggerContext>(ctx));
            ClassLoaderContextSelector.CONTEXT_MAP.putIfAbsent(name, r);
            ctx = (LoggerContext)((WeakReference)((AtomicReference)ClassLoaderContextSelector.CONTEXT_MAP.get(name)).get()).get();
            return ctx;
        }
        WeakReference weakRef = (WeakReference)ref.get();
        LoggerContext ctx = (LoggerContext)weakRef.get();
        if (ctx != null) {
            if (ctx.getConfigLocation() == null && configLocation != null) {
                ClassLoaderContextSelector.LOGGER.debug("Setting configuration to {}", (Object)configLocation);
                ctx.setConfigLocation(configLocation);
            } else if (ctx.getConfigLocation() != null && configLocation != null && !ctx.getConfigLocation().equals(configLocation)) {
                ClassLoaderContextSelector.LOGGER.warn("locateContext called with URI {}. Existing LoggerContext has URI {}", (Object)configLocation, (Object)ctx.getConfigLocation());
            }
            return ctx;
        }
        ctx = this.createSpongeContext(loader, name, configLocation);
        ref.compareAndSet(weakRef, new WeakReference<LoggerContext>(ctx));
        return ctx;
    }

    protected LoggerContext createSpongeContext(ClassLoader transformingLoader, String name, URI configLocation) {
        BiFunction transformingContextProvider;
        try {
            Class<?> clazz = Class.forName(CONTEXT_PROVIDER_CLASS, true, transformingLoader);
            transformingContextProvider = (BiFunction)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            ClassLoaderContextSelector.LOGGER.error("Failed to create context provider instance", (Throwable)ex);
            throw new IllegalStateException(ex);
        }
        return (LoggerContext)transformingContextProvider.apply(name, configLocation);
    }
}

