/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.client.gui.widget.list;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.narration.NarrationSupplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.vanilla.util.Bounds;

public class FilterableList<P extends FilterableList<P, E>, E extends Entry<P, E>>
extends AbstractSelectionList<E> {
    private static final Component USAGE_NARRATION = Component.translatable((String)"narration.selection.usage");
    private final Screen screen;
    private Supplier<List<E>> filterSupplier;
    private Consumer<E> selectConsumer;
    protected final Font fontRenderer;
    protected E currentHoveredEntry;

    public FilterableList(Screen screen, int x, int y, int width, int height, int entryHeight) {
        super(Minecraft.getInstance(), width, height, y, entryHeight);
        this.screen = screen;
        this.setX(x);
        this.fontRenderer = Minecraft.getInstance().font;
    }

    public Screen getScreen() {
        return this.screen;
    }

    public int getBottom() {
        return this.getY() + this.headerHeight;
    }

    public E getCurrentHoveredEntry() {
        return this.currentHoveredEntry;
    }

    public P setCurrentHoveredEntry(E currentHoveredEntry) {
        this.currentHoveredEntry = currentHoveredEntry;
        return (P)((Object)this);
    }

    @SafeVarargs
    public final P addEntries(E ... entries) {
        this.addEntries(Arrays.asList(entries));
        return (P)((Object)this);
    }

    public P addEntries(List<E> entries) {
        entries.forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
        return (P)((Object)this);
    }

    public Consumer<E> getSelectConsumer() {
        return this.selectConsumer;
    }

    public P setSelectConsumer(Consumer<E> selectConsumer) {
        this.selectConsumer = selectConsumer;
        return (P)((Object)this);
    }

    public Supplier<List<E>> getFilterSupplier() {
        return this.filterSupplier;
    }

    public P setFilterSupplier(Supplier<List<E>> filterSupplier) {
        this.filterSupplier = filterSupplier;
        return (P)((Object)this);
    }

    public int getRowHeight() {
        return this.itemHeight;
    }

    public int getRowWidth() {
        return this.width - 12;
    }

    public int getRowLeft() {
        return this.getX() + 4;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.width - 6;
    }

    public void setSelected(@Nullable E entry) {
        if (this.selectConsumer != null) {
            this.selectConsumer.accept(entry);
        }
        super.setSelected(entry);
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.updateScrollingState(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (!this.isMouseOver(p_mouseClicked_1_, p_mouseClicked_3_)) {
            return false;
        }
        Entry e = (Entry)this.getEntryAtPosition(p_mouseClicked_1_, p_mouseClicked_3_);
        if (e != null) {
            if (e.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
                this.setFocused((GuiEventListener)e);
                this.setDragging(true);
                return true;
            }
        } else if (p_mouseClicked_5_ == 0) {
            this.clickedHeader((int)(p_mouseClicked_1_ - (double)(this.getX() + this.width / 2 - this.getRowWidth() / 2)), (int)(p_mouseClicked_3_ - (double)this.getY()) + (int)this.getScrollAmount() - 4);
            return true;
        }
        return true;
    }

    protected void renderListItems(GuiGraphics $$0, int $$1, int $$2, float $$3) {
        List<E> filteredList;
        List<E> list = filteredList = this.filterSupplier == null ? this.children() : this.filterSupplier.get();
        if (filteredList.isEmpty()) {
            Font font = this.minecraft.font;
            String noResults = "No results...";
            int noResultsWidth = font.width("No results...");
            $$0.drawString(font, "No results...", this.width / 2 + this.getX() - noResultsWidth / 2, this.getY() + 10, ChatFormatting.GRAY.getColor().intValue());
            return;
        }
        int $$4 = this.getRowLeft();
        int $$5 = this.getRowWidth();
        int $$6 = this.itemHeight - 4;
        int $$7 = filteredList.size();
        for (int $$8 = 0; $$8 < $$7; ++$$8) {
            int $$9 = this.getRowTop($$8);
            int $$10 = this.getRowBottom($$8);
            if ($$10 < this.getY() || $$9 > this.getBottom()) continue;
            this.renderItemFromList(filteredList, $$0, $$1, $$2, $$3, $$8, $$4, $$9, $$5, $$6);
        }
    }

    private void renderItemFromList(List<E> list, GuiGraphics $$0, int $$1, int $$2, float $$3, int $$4, int $$5, int $$6, int $$7, int $$8) {
        Entry $$9 = (Entry)((Object)list.get($$4));
        $$9.renderBack($$0, $$4, $$6, $$5, $$7, $$8, $$1, $$2, Objects.equals(this.getHovered(), (Object)$$9), $$3);
        if (this.isSelectedItem($$4)) {
            int $$10 = this.isFocused() ? -1 : -8355712;
            this.renderSelection($$0, $$6, $$7, $$8, $$10, -16777216);
        }
        $$9.render($$0, $$4, $$6, $$5, $$7, $$8, $$1, $$2, Objects.equals(this.getHovered(), (Object)$$9), $$3);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationConsumer) {
        @Nullable E hovered = this.getCurrentHoveredEntry();
        if (hovered != null) {
            this.narrateListElementPosition(narrationConsumer, (AbstractSelectionList.Entry)hovered);
            hovered.updateNarration(narrationConsumer);
        } else {
            Entry selected = (Entry)this.getSelected();
            if (selected != null) {
                this.narrateListElementPosition(narrationConsumer.nest(), selected);
                selected.updateNarration(narrationConsumer);
            }
        }
        if (this.isFocused()) {
            narrationConsumer.add(NarratedElementType.USAGE, USAGE_NARRATION);
        }
    }

    public static abstract class Entry<P extends FilterableList<P, E>, E extends Entry<P, E>>
    extends AbstractSelectionList.Entry<E>
    implements NarrationSupplier {
        private final P parentList;

        public Entry(P parentList) {
            this.parentList = parentList;
        }

        public P getParentList() {
            return this.parentList;
        }

        public abstract Bounds getInteractBounds();

        public void render(GuiGraphics stack, int p_render_1_, int renderY, int renderX, int p_render_4_, int p_render_5_, int mouseX, int mouseY, boolean p_render_8_, float p_render_9_) {
            if (this.getInteractBounds().isInBounds(mouseX, mouseY, renderX, renderY)) {
                ((FilterableList)((Object)this.parentList)).currentHoveredEntry = this;
            } else if (((FilterableList)((Object)this.parentList)).getCurrentHoveredEntry() == this) {
                ((FilterableList)((Object)this.parentList)).currentHoveredEntry = null;
            }
        }
    }
}

