/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.launch.plugin;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.invoke.MethodHandles;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.spongepowered.common.inject.plugin.PluginModule;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.Environment;
import org.spongepowered.plugin.InvalidPluginException;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.builtin.jvm.JVMPluginLoader;
import org.spongepowered.plugin.builtin.jvm.locator.JVMPluginResource;
import org.spongepowered.vanilla.launch.plugin.VanillaJavaPluginContainer;

public final class JavaPluginLoader
extends JVMPluginLoader<JVMPluginResource, VanillaJavaPluginContainer> {
    private final ArtifactVersion version = new DefaultArtifactVersion("1.0");
    private static final MethodHandles.Lookup SPONGE_LOOKUP = MethodHandles.lookup();

    public ArtifactVersion version() {
        return this.version;
    }

    public VanillaJavaPluginContainer loadPlugin(Environment environment, PluginCandidate<JVMPluginResource> candidate, ClassLoader targetClassLoader) throws InvalidPluginException {
        VanillaJavaPluginContainer container = new VanillaJavaPluginContainer(candidate);
        try {
            Object plugin;
            String mainClass = container.metadata().entrypoint();
            Class<?> pluginClass = Class.forName(mainClass, true, targetClassLoader);
            container.initializeLookup(MethodHandles.privateLookupIn(pluginClass, SPONGE_LOOKUP));
            Injector parentInjector = ((Launch)Launch.instance()).lifecycle().platformInjector();
            if (parentInjector != null) {
                Injector childInjector = parentInjector.createChildInjector(new Module[]{new PluginModule((PluginContainer)container, pluginClass)});
                plugin = childInjector.getInstance(pluginClass);
            } else {
                plugin = pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            container.initializeInstance(plugin);
            return container;
        }
        catch (Exception ex) {
            throw new InvalidPluginException("An error occurred creating an instance of plugin '" + container.metadata().id() + "'!", (Throwable)ex);
        }
    }
}

