/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.server.packs;

import java.nio.file.FileSystem;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import org.apache.commons.io.FilenameUtils;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.builtin.jvm.locator.JVMPluginResource;
import org.spongepowered.vanilla.bridge.server.packs.repository.PackRepositoryBridge_Vanilla;
import org.spongepowered.vanilla.launch.plugin.VanillaPluginManager;
import org.spongepowered.vanilla.server.packs.PluginPackResources;

public final class PluginRepositorySource
implements RepositorySource {
    public static final PackSelectionConfig PLUGIN_SELECTION_CONFIG = new PackSelectionConfig(false, Pack.Position.BOTTOM, false);
    private final PackRepository repository;

    public PluginRepositorySource(PackRepository repository) {
        this.repository = repository;
    }

    public void loadPacks(Consumer<Pack> callback) {
        VanillaPluginManager pluginManager = (VanillaPluginManager)((Launch)Launch.instance()).pluginManager();
        for (PluginContainer pluginContainer : pluginManager.plugins()) {
            String extension;
            String id = "plugin-" + pluginContainer.metadata().id();
            PluginResource resource = pluginManager.resource(pluginContainer);
            Supplier<FileSystem> fileSystemSupplier = null;
            if (resource instanceof JVMPluginResource && "jar".equals(extension = FilenameUtils.getExtension((String)resource.path().getFileName().toString()))) {
                fileSystemSupplier = () -> ((JVMPluginResource)((JVMPluginResource)resource)).fileSystem();
            }
            PackLocationInfo info = new PackLocationInfo(id, (Component)Component.literal((String)id), PackSource.DEFAULT, Optional.empty());
            final PluginPackResources packResources = new PluginPackResources(info, pluginContainer, fileSystemSupplier);
            Pack.ResourcesSupplier packSupplier = new Pack.ResourcesSupplier(){

                public PackResources openPrimary(PackLocationInfo var1) {
                    return packResources;
                }

                public PackResources openFull(PackLocationInfo var1, Pack.Metadata var2) {
                    return packResources;
                }
            };
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)info, (Pack.ResourcesSupplier)packSupplier, (PackType)PackType.SERVER_DATA, (PackSelectionConfig)PLUGIN_SELECTION_CONFIG);
            ((PackRepositoryBridge_Vanilla)this.repository).bridge$registerResourcePack(pluginContainer, pack);
            callback.accept(pack);
        }
    }
}

