/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer.model.mojang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.vanilla.installer.model.mojang.BundleElement;
import org.spongepowered.vanilla.installer.model.mojang.FormatVersion;

public record BundlerMetadata(FormatVersion version, Set<BundleElement> libraries, BundleElement server, @Nullable String mainClass) {
    private static final String MAIN_CLASS = "META-INF/main-class";

    public BundlerMetadata(FormatVersion version, Set<BundleElement> libraries, BundleElement server, @Nullable String mainClass) {
        libraries = Set.copyOf(libraries);
    }

    public static Optional<BundlerMetadata> read(Path jar) throws IOException {
        try (JarFile file = new JarFile(jar.toFile());){
            Optional<BundlerMetadata> optional = BundlerMetadata.read(file);
            return optional;
        }
    }

    public static Optional<BundlerMetadata> read(JarFile file) throws IOException {
        String mainClass;
        Set<BundleElement> libraries;
        BundleElement serverJar;
        Manifest manifest = file.getManifest();
        @Nullable String formatVersion = manifest.getMainAttributes().getValue("Bundler-Format");
        if (formatVersion == null) {
            return Optional.empty();
        }
        FormatVersion parsed = FormatVersion.parse(formatVersion);
        try (Stream<BundleElement> stream = BundlerMetadata.readIndex(file, "versions");){
            serverJar = stream.findFirst().orElse(null);
        }
        if (serverJar == null) {
            throw new IllegalArgumentException("Missing server jar from versions list");
        }
        try (Stream<BundleElement> elements = BundlerMetadata.readIndex(file, "libraries");){
            libraries = elements.collect(Collectors.toUnmodifiableSet());
        }
        JarEntry mainClassEntry = file.getJarEntry(MAIN_CLASS);
        if (mainClassEntry == null) {
            throw new IllegalArgumentException("Missing main class entry in bundle");
        }
        try (BufferedReader read = new BufferedReader(new InputStreamReader(file.getInputStream(mainClassEntry), StandardCharsets.UTF_8));){
            mainClass = read.readLine();
        }
        return Optional.of(new BundlerMetadata(parsed, libraries, serverJar, mainClass));
    }

    private static Stream<BundleElement> readIndex(JarFile jar, String index) throws IOException {
        @Nullable JarEntry entry = jar.getJarEntry("META-INF/" + index + ".list");
        if (entry == null) {
            return Stream.empty();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(jar.getInputStream(entry), StandardCharsets.UTF_8));
        return (Stream)reader.lines().map(x -> x.split("\t")).map(line -> new BundleElement(line[0], line[1], "META-INF/" + index + "/" + line[2])).onClose(() -> {
            try {
                reader.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }
}

