/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.connection;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.proxy.InboundConnection;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PreLoginEvent
implements ResultedEvent<PreLoginComponentResult> {
    private final InboundConnection connection;
    private final String username;
    private PreLoginComponentResult result;

    public PreLoginEvent(InboundConnection connection, String username) {
        this.connection = Preconditions.checkNotNull(connection, "connection");
        this.username = Preconditions.checkNotNull(username, "username");
        this.result = PreLoginComponentResult.allowed();
    }

    public InboundConnection getConnection() {
        return this.connection;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public PreLoginComponentResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(@NonNull PreLoginComponentResult result) {
        this.result = Preconditions.checkNotNull(result, "result");
    }

    public String toString() {
        return "PreLoginEvent{connection=" + this.connection + ", username='" + this.username + '\'' + ", result=" + this.result + '}';
    }

    public static final class PreLoginComponentResult
    implements ResultedEvent.Result {
        private static final PreLoginComponentResult ALLOWED = new PreLoginComponentResult(Result.ALLOWED, null);
        private static final PreLoginComponentResult FORCE_ONLINEMODE = new PreLoginComponentResult(Result.FORCE_ONLINE, null);
        private static final PreLoginComponentResult FORCE_OFFLINEMODE = new PreLoginComponentResult(Result.FORCE_OFFLINE, null);
        private final Result result;
        private final Component reason;

        private PreLoginComponentResult(Result result, @Nullable Component reason) {
            this.result = result;
            this.reason = reason;
        }

        @Override
        public boolean isAllowed() {
            return this.result != Result.DISALLOWED;
        }

        public Optional<Component> getReasonComponent() {
            return Optional.ofNullable(this.reason);
        }

        public boolean isOnlineModeAllowed() {
            return this.result == Result.FORCE_ONLINE;
        }

        public boolean isForceOfflineMode() {
            return this.result == Result.FORCE_OFFLINE;
        }

        public String toString() {
            switch (this.result) {
                case ALLOWED: {
                    return "allowed";
                }
                case FORCE_OFFLINE: {
                    return "allowed with force offline mode";
                }
                case FORCE_ONLINE: {
                    return "allowed with online mode";
                }
            }
            return "denied";
        }

        public static PreLoginComponentResult allowed() {
            return ALLOWED;
        }

        public static PreLoginComponentResult forceOnlineMode() {
            return FORCE_ONLINEMODE;
        }

        public static PreLoginComponentResult forceOfflineMode() {
            return FORCE_OFFLINEMODE;
        }

        public static PreLoginComponentResult denied(Component reason) {
            Preconditions.checkNotNull(reason, "reason");
            return new PreLoginComponentResult(Result.DISALLOWED, reason);
        }

        private static enum Result {
            ALLOWED,
            FORCE_ONLINE,
            FORCE_OFFLINE,
            DISALLOWED;

        }
    }
}

