/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.event;

import com.google.common.reflect.TypeToken;
import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.EventTask;
import com.velocitypowered.proxy.event.UntargetedEventHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.lanternpowered.lmbda.LambdaFactory;
import org.lanternpowered.lmbda.LambdaType;

final class CustomHandlerAdapter<F> {
    final String name;
    private final Function<F, BiFunction<Object, Object, EventTask>> handlerBuilder;
    final Predicate<Method> filter;
    final BiConsumer<Method, List<String>> validator;
    private final LambdaType<F> functionType;
    private final MethodHandles.Lookup methodHandlesLookup;

    CustomHandlerAdapter(String name, Predicate<Method> filter, BiConsumer<Method, List<String>> validator, TypeToken<F> invokeFunctionType, Function<F, BiFunction<Object, Object, EventTask>> handlerBuilder, MethodHandles.Lookup methodHandlesLookup) {
        this.name = name;
        this.filter = filter;
        this.validator = validator;
        this.functionType = LambdaType.of(invokeFunctionType.getRawType());
        this.handlerBuilder = handlerBuilder;
        this.methodHandlesLookup = methodHandlesLookup;
    }

    UntargetedEventHandler buildUntargetedHandler(Method method) throws IllegalAccessException {
        MethodHandle methodHandle = this.methodHandlesLookup.unreflect(method);
        MethodHandles.Lookup defineLookup = MethodHandles.privateLookupIn(method.getDeclaringClass(), this.methodHandlesLookup);
        LambdaType<F> lambdaType2 = this.functionType.defineClassesWith(defineLookup);
        F invokeFunction = LambdaFactory.create(lambdaType2, methodHandle);
        final BiFunction<Object, Object, EventTask> handlerFunction = this.handlerBuilder.apply(invokeFunction);
        return targetInstance -> new EventHandler(){

            public void execute(Object event) {
                throw new UnsupportedOperationException();
            }

            public @Nullable EventTask executeAsync(Object event) {
                return (EventTask)handlerFunction.apply(targetInstance, event);
            }
        };
    }
}

