/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ResourcePackRequest
implements MinecraftPacket {
    private @MonotonicNonNull String url;
    private @MonotonicNonNull String hash;
    private boolean isRequired;
    private @Nullable Component prompt;

    public @Nullable String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public @Nullable String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    public @Nullable Component getPrompt() {
        return this.prompt;
    }

    public void setPrompt(Component prompt) {
        this.prompt = prompt;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        this.url = ProtocolUtils.readString(buf);
        this.hash = ProtocolUtils.readString(buf);
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_17) >= 0) {
            this.isRequired = buf.readBoolean();
            this.prompt = buf.readBoolean() ? GsonComponentSerializer.gson().deserialize(ProtocolUtils.readString(buf)) : null;
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        if (this.url == null || this.hash == null) {
            throw new IllegalStateException("Packet not fully filled in yet!");
        }
        ProtocolUtils.writeString(buf, this.url);
        ProtocolUtils.writeString(buf, this.hash);
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_17) >= 0) {
            buf.writeBoolean(this.isRequired);
            if (this.prompt != null) {
                buf.writeBoolean(true);
                ProtocolUtils.writeString(buf, (CharSequence)GsonComponentSerializer.gson().serialize(this.prompt));
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    public String toString() {
        return "ResourcePackRequest{url='" + this.url + "', hash='" + this.hash + "', isRequired=" + this.isRequired + ", prompt='" + this.prompt + "'}";
    }
}

