/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.google.common.base.MoreObjects;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TabCompleteRequest
implements MinecraftPacket {
    private static final int VANILLA_MAX_TAB_COMPLETE_LEN = 2048;
    private @Nullable String command;
    private int transactionId;
    private boolean assumeCommand;
    private boolean hasPosition;
    private long position;

    public String getCommand() {
        if (this.command == null) {
            throw new IllegalStateException("Command is not specified");
        }
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean isAssumeCommand() {
        return this.assumeCommand;
    }

    public void setAssumeCommand(boolean assumeCommand) {
        this.assumeCommand = assumeCommand;
    }

    public boolean hasPosition() {
        return this.hasPosition;
    }

    public void setHasPosition(boolean hasPosition) {
        this.hasPosition = hasPosition;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("command", this.command).add("transactionId", this.transactionId).add("assumeCommand", this.assumeCommand).add("hasPosition", this.hasPosition).add("position", this.position).toString();
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_13) >= 0) {
            this.transactionId = ProtocolUtils.readVarInt(buf);
            this.command = ProtocolUtils.readString(buf, 2048);
        } else {
            this.command = ProtocolUtils.readString(buf, 2048);
            if (version.compareTo(ProtocolVersion.MINECRAFT_1_9) >= 0) {
                this.assumeCommand = buf.readBoolean();
            }
            if (version.compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
                this.hasPosition = buf.readBoolean();
                if (this.hasPosition) {
                    this.position = buf.readLong();
                }
            }
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (this.command == null) {
            throw new IllegalStateException("Command is not specified");
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_13) >= 0) {
            ProtocolUtils.writeVarInt(buf, this.transactionId);
            ProtocolUtils.writeString(buf, this.command);
        } else {
            ProtocolUtils.writeString(buf, this.command);
            if (version.compareTo(ProtocolVersion.MINECRAFT_1_9) >= 0) {
                buf.writeBoolean(this.assumeCommand);
            }
            if (version.compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
                buf.writeBoolean(this.hasPosition);
                if (this.hasPosition) {
                    buf.writeLong(this.position);
                }
            }
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

