/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.brigadier;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.velocitypowered.proxy.protocol.packet.brigadier.ArgumentPropertySerializer;
import io.netty.buffer.ByteBuf;

class IntegerArgumentPropertySerializer
implements ArgumentPropertySerializer<IntegerArgumentType> {
    static final IntegerArgumentPropertySerializer INTEGER = new IntegerArgumentPropertySerializer();
    static final byte HAS_MINIMUM = 1;
    static final byte HAS_MAXIMUM = 2;

    private IntegerArgumentPropertySerializer() {
    }

    @Override
    public IntegerArgumentType deserialize(ByteBuf buf) {
        byte flags = buf.readByte();
        int minimum = (flags & 1) != 0 ? buf.readInt() : Integer.MIN_VALUE;
        int maximum = (flags & 2) != 0 ? buf.readInt() : Integer.MAX_VALUE;
        return IntegerArgumentType.integer(minimum, maximum);
    }

    @Override
    public void serialize(IntegerArgumentType object, ByteBuf buf) {
        boolean hasMinimum = object.getMinimum() != Integer.MIN_VALUE;
        boolean hasMaximum = object.getMaximum() != Integer.MAX_VALUE;
        byte flag = IntegerArgumentPropertySerializer.getFlags(hasMinimum, hasMaximum);
        buf.writeByte(flag);
        if (hasMinimum) {
            buf.writeInt(object.getMinimum());
        }
        if (hasMaximum) {
            buf.writeInt(object.getMaximum());
        }
    }

    static byte getFlags(boolean hasMinimum, boolean hasMaximum) {
        byte flags = 0;
        if (hasMinimum) {
            flags = (byte)(flags | 1);
        }
        if (hasMaximum) {
            flags = (byte)(flags | 2);
        }
        return flags;
    }
}

