/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.backend;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.tree.RootCommandNode;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.command.PlayerAvailableCommandsEvent;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.command.CommandGraphInjector;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.BungeeCordMessageResponder;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ClientPlaySessionHandler;
import com.velocitypowered.proxy.connection.player.VelocityResourcePackInfo;
import com.velocitypowered.proxy.connection.util.ConnectionMessages;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.packet.AvailableCommands;
import com.velocitypowered.proxy.protocol.packet.BossBar;
import com.velocitypowered.proxy.protocol.packet.Disconnect;
import com.velocitypowered.proxy.protocol.packet.KeepAlive;
import com.velocitypowered.proxy.protocol.packet.PlayerListItem;
import com.velocitypowered.proxy.protocol.packet.PluginMessage;
import com.velocitypowered.proxy.protocol.packet.ResourcePackRequest;
import com.velocitypowered.proxy.protocol.packet.TabCompleteResponse;
import com.velocitypowered.proxy.protocol.util.PluginMessageUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.timeout.ReadTimeoutException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackendPlaySessionHandler
implements MinecraftSessionHandler {
    private static final Pattern PLAUSIBLE_SHA1_HASH = Pattern.compile("^[a-z0-9]{40}$");
    private static final Logger logger = LogManager.getLogger(BackendPlaySessionHandler.class);
    private static final boolean BACKPRESSURE_LOG = Boolean.getBoolean("velocity.log-server-backpressure");
    private static final int MAXIMUM_PACKETS_TO_FLUSH = Integer.getInteger("velocity.max-packets-per-flush", 8192);
    private final VelocityServer server;
    private final VelocityServerConnection serverConn;
    private final ClientPlaySessionHandler playerSessionHandler;
    private final MinecraftConnection playerConnection;
    private final BungeeCordMessageResponder bungeecordMessageResponder;
    private boolean exceptionTriggered = false;
    private int packetsFlushed;

    BackendPlaySessionHandler(VelocityServer server, VelocityServerConnection serverConn) {
        this.server = server;
        this.serverConn = serverConn;
        this.playerConnection = serverConn.getPlayer().getConnection();
        MinecraftSessionHandler psh = this.playerConnection.getSessionHandler();
        if (!(psh instanceof ClientPlaySessionHandler)) {
            throw new IllegalStateException("Initializing BackendPlaySessionHandler with no backing client play session handler!");
        }
        this.playerSessionHandler = (ClientPlaySessionHandler)psh;
        this.bungeecordMessageResponder = new BungeeCordMessageResponder(server, serverConn.getPlayer());
    }

    @Override
    public void activated() {
        this.serverConn.getServer().addPlayer(this.serverConn.getPlayer());
        if (this.server.getConfiguration().isBungeePluginChannelEnabled()) {
            MinecraftConnection serverMc = this.serverConn.ensureConnected();
            serverMc.write(PluginMessageUtil.constructChannelsPacket(serverMc.getProtocolVersion(), ImmutableList.of(BungeeCordMessageResponder.getBungeeCordChannel(serverMc.getProtocolVersion()))));
        }
    }

    @Override
    public boolean beforeHandle() {
        if (!this.serverConn.isActive()) {
            this.serverConn.disconnect();
            return true;
        }
        return false;
    }

    @Override
    public boolean handle(KeepAlive packet) {
        this.serverConn.getPendingPings().put(packet.getRandomId(), System.currentTimeMillis());
        return false;
    }

    @Override
    public boolean handle(Disconnect packet) {
        this.serverConn.disconnect();
        this.serverConn.getPlayer().handleConnectionException((RegisteredServer)this.serverConn.getServer(), packet, true);
        return true;
    }

    @Override
    public boolean handle(BossBar packet) {
        if (packet.getAction() == 0) {
            this.playerSessionHandler.getServerBossBars().add(packet.getUuid());
        } else if (packet.getAction() == 1) {
            this.playerSessionHandler.getServerBossBars().remove(packet.getUuid());
        }
        return false;
    }

    @Override
    public boolean handle(ResourcePackRequest packet) {
        VelocityResourcePackInfo.BuilderImpl builder = new VelocityResourcePackInfo.BuilderImpl(Preconditions.checkNotNull(packet.getUrl())).setPrompt(packet.getPrompt()).setShouldForce(packet.isRequired());
        if (packet.getHash() != null && !Preconditions.checkNotNull(packet.getHash()).isEmpty() && PLAUSIBLE_SHA1_HASH.matcher(packet.getHash()).matches()) {
            builder.setHash(ByteBufUtil.decodeHexDump(packet.getHash()));
        }
        this.serverConn.getPlayer().queueResourcePack(builder.build());
        return true;
    }

    @Override
    public boolean handle(PluginMessage packet) {
        if (this.bungeecordMessageResponder.process(packet)) {
            return true;
        }
        if (PluginMessageUtil.isRegister(packet)) {
            this.serverConn.getPlayer().getKnownChannels().addAll(PluginMessageUtil.getChannels(packet));
            return false;
        }
        if (PluginMessageUtil.isUnregister(packet)) {
            this.serverConn.getPlayer().getKnownChannels().removeAll(PluginMessageUtil.getChannels(packet));
            return false;
        }
        if (PluginMessageUtil.isMcBrand(packet)) {
            PluginMessage rewritten = PluginMessageUtil.rewriteMinecraftBrand(packet, this.server.getVersion(), this.playerConnection.getProtocolVersion());
            this.playerConnection.write(rewritten);
            return true;
        }
        if (this.serverConn.getPhase().handle(this.serverConn, this.serverConn.getPlayer(), packet)) {
            return true;
        }
        ChannelIdentifier id = this.server.getChannelRegistrar().getFromId(packet.getChannel());
        if (id == null) {
            return false;
        }
        byte[] copy = ByteBufUtil.getBytes(packet.content());
        PluginMessageEvent event = new PluginMessageEvent(this.serverConn, this.serverConn.getPlayer(), id, copy);
        ((CompletableFuture)this.server.getEventManager().fire(event).thenAcceptAsync(pme -> {
            if (pme.getResult().isAllowed() && !this.playerConnection.isClosed()) {
                PluginMessage copied = new PluginMessage(packet.getChannel(), Unpooled.wrappedBuffer(copy));
                this.playerConnection.write(copied);
            }
        }, (Executor)this.playerConnection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception while handling plugin message {}", (Object)packet, ex);
            return null;
        });
        return true;
    }

    @Override
    public boolean handle(TabCompleteResponse packet) {
        this.playerSessionHandler.handleTabCompleteResponse(packet);
        return true;
    }

    @Override
    public boolean handle(PlayerListItem packet) {
        this.serverConn.getPlayer().getTabList().processBackendPacket(packet);
        return false;
    }

    @Override
    public boolean handle(AvailableCommands commands) {
        RootCommandNode<CommandSource> rootNode = commands.getRootNode();
        if (this.server.getConfiguration().isAnnounceProxyCommands()) {
            CommandGraphInjector<CommandSource> injector = this.server.getCommandManager().getInjector();
            injector.inject(rootNode, this.serverConn.getPlayer());
        }
        ((CompletableFuture)this.server.getEventManager().fire(new PlayerAvailableCommandsEvent(this.serverConn.getPlayer(), rootNode)).thenAcceptAsync(event -> this.playerConnection.write(commands), (Executor)this.playerConnection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception while handling available commands for {}", (Object)this.playerConnection, ex);
            return null;
        });
        return true;
    }

    @Override
    public void handleGeneric(MinecraftPacket packet) {
        if (packet instanceof PluginMessage) {
            ((PluginMessage)packet).retain();
        }
        this.playerConnection.delayedWrite(packet);
        if (++this.packetsFlushed >= MAXIMUM_PACKETS_TO_FLUSH) {
            this.playerConnection.flush();
            this.packetsFlushed = 0;
        }
    }

    @Override
    public void handleUnknown(ByteBuf buf) {
        this.playerConnection.delayedWrite(buf.retain());
        if (++this.packetsFlushed >= MAXIMUM_PACKETS_TO_FLUSH) {
            this.playerConnection.flush();
            this.packetsFlushed = 0;
        }
    }

    @Override
    public void readCompleted() {
        this.playerConnection.flush();
        this.packetsFlushed = 0;
    }

    @Override
    public void exception(Throwable throwable) {
        this.exceptionTriggered = true;
        this.serverConn.getPlayer().handleConnectionException((RegisteredServer)this.serverConn.getServer(), throwable, !(throwable instanceof ReadTimeoutException));
    }

    public VelocityServer getServer() {
        return this.server;
    }

    @Override
    public void disconnected() {
        this.serverConn.getServer().removePlayer(this.serverConn.getPlayer());
        if (!this.serverConn.isGracefulDisconnect() && !this.exceptionTriggered) {
            if (this.server.getConfiguration().isFailoverOnUnexpectedServerDisconnect()) {
                this.serverConn.getPlayer().handleConnectionException((RegisteredServer)this.serverConn.getServer(), Disconnect.create(ConnectionMessages.INTERNAL_SERVER_CONNECTION_ERROR, ProtocolVersion.MINECRAFT_1_16), true);
            } else {
                this.serverConn.getPlayer().disconnect(ConnectionMessages.INTERNAL_SERVER_CONNECTION_ERROR);
            }
        }
    }

    @Override
    public void writabilityChanged() {
        Channel serverChan = this.serverConn.ensureConnected().getChannel();
        boolean writable = serverChan.isWritable();
        if (BACKPRESSURE_LOG) {
            if (writable) {
                logger.info("{} is not writable, not auto-reading player connection data", (Object)this.serverConn);
            } else {
                logger.info("{} is writable, will auto-read player connection data", (Object)this.serverConn);
            }
        }
        this.playerConnection.setAutoReading(writable);
    }
}

