/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.PlayerModInfoEvent;
import com.velocitypowered.api.event.player.PlayerResourcePackStatusEvent;
import com.velocitypowered.api.event.player.PlayerSettingsChangedEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.permission.PermissionFunction;
import com.velocitypowered.api.permission.PermissionProvider;
import com.velocitypowered.api.permission.Tristate;
import com.velocitypowered.api.proxy.ConnectionRequestBuilder;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.player.PlayerSettings;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.api.util.ModInfo;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftConnectionAssociation;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ClientConnectionPhase;
import com.velocitypowered.proxy.connection.client.ClientSettingsWrapper;
import com.velocitypowered.proxy.connection.player.VelocityResourcePackInfo;
import com.velocitypowered.proxy.connection.util.ConnectionMessages;
import com.velocitypowered.proxy.connection.util.ConnectionRequestResults;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.Chat;
import com.velocitypowered.proxy.protocol.packet.ClientSettings;
import com.velocitypowered.proxy.protocol.packet.Disconnect;
import com.velocitypowered.proxy.protocol.packet.HeaderAndFooter;
import com.velocitypowered.proxy.protocol.packet.KeepAlive;
import com.velocitypowered.proxy.protocol.packet.PluginMessage;
import com.velocitypowered.proxy.protocol.packet.ResourcePackRequest;
import com.velocitypowered.proxy.protocol.packet.title.GenericTitlePacket;
import com.velocitypowered.proxy.server.VelocityRegisteredServer;
import com.velocitypowered.proxy.tablist.VelocityTabList;
import com.velocitypowered.proxy.tablist.VelocityTabListLegacy;
import com.velocitypowered.proxy.util.ClosestLocaleMatcher;
import com.velocitypowered.proxy.util.DurationUtils;
import com.velocitypowered.proxy.util.collect.CappedSet;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import net.kyori.adventure.translation.GlobalTranslator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class ConnectedPlayer
implements MinecraftConnectionAssociation,
Player {
    private static final int MAX_PLUGIN_CHANNELS = 1024;
    private static final PlainComponentSerializer PASS_THRU_TRANSLATE = new PlainComponentSerializer(c -> "", TranslatableComponent::key);
    static final PermissionProvider DEFAULT_PERMISSIONS = s -> PermissionFunction.ALWAYS_UNDEFINED;
    private static final Logger logger = LogManager.getLogger(ConnectedPlayer.class);
    private final Identity identity = new IdentityImpl();
    private final MinecraftConnection connection;
    private final @Nullable InetSocketAddress virtualHost;
    private GameProfile profile;
    private PermissionFunction permissionFunction;
    private int tryIndex = 0;
    private long ping = -1L;
    private final boolean onlineMode;
    private @Nullable VelocityServerConnection connectedServer;
    private @Nullable VelocityServerConnection connectionInFlight;
    private @Nullable PlayerSettings settings;
    private @Nullable ModInfo modInfo;
    private Component playerListHeader = Component.empty();
    private Component playerListFooter = Component.empty();
    private final VelocityTabList tabList;
    private final VelocityServer server;
    private ClientConnectionPhase connectionPhase;
    private final Collection<String> knownChannels;
    private final CompletableFuture<Void> teardownFuture = new CompletableFuture();
    private @MonotonicNonNull List<String> serversToTry = null;
    private @MonotonicNonNull Boolean previousResourceResponse;
    private final Queue<ResourcePackInfo> outstandingResourcePacks = new ArrayDeque<ResourcePackInfo>();
    private @Nullable ResourcePackInfo pendingResourcePack;
    private @Nullable ResourcePackInfo appliedResourcePack;
    @NotNull
    private final Pointers pointers = (Pointers)((Pointers.Builder)Player.super.pointers().toBuilder()).withDynamic(Identity.UUID, this::getUniqueId).withDynamic(Identity.NAME, this::getUsername).withStatic(PermissionChecker.POINTER, this.getPermissionChecker()).build();
    private @Nullable String clientBrand;
    private @Nullable Locale effectiveLocale;

    ConnectedPlayer(VelocityServer server, GameProfile profile, MinecraftConnection connection, @Nullable InetSocketAddress virtualHost, boolean onlineMode) {
        this.server = server;
        this.profile = profile;
        this.connection = connection;
        this.virtualHost = virtualHost;
        this.permissionFunction = PermissionFunction.ALWAYS_UNDEFINED;
        this.connectionPhase = connection.getType().getInitialClientPhase();
        this.knownChannels = CappedSet.create(1024);
        this.onlineMode = onlineMode;
        this.tabList = connection.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0 ? new VelocityTabList(this) : new VelocityTabListLegacy(this);
    }

    @Override
    public @NonNull Identity identity() {
        return this.identity;
    }

    @Override
    public String getUsername() {
        return this.profile.getName();
    }

    @Override
    public Locale getEffectiveLocale() {
        if (this.effectiveLocale == null && this.settings != null) {
            return this.settings.getLocale();
        }
        return this.effectiveLocale;
    }

    @Override
    public void setEffectiveLocale(Locale locale) {
        this.effectiveLocale = locale;
    }

    @Override
    public UUID getUniqueId() {
        return this.profile.getId();
    }

    @Override
    public Optional<ServerConnection> getCurrentServer() {
        return Optional.ofNullable(this.connectedServer);
    }

    public VelocityServerConnection ensureAndGetCurrentServer() {
        VelocityServerConnection con = this.connectedServer;
        if (con == null) {
            throw new IllegalStateException("Not connected to server!");
        }
        return con;
    }

    @Override
    public GameProfile getGameProfile() {
        return this.profile;
    }

    public MinecraftConnection getConnection() {
        return this.connection;
    }

    @Override
    public long getPing() {
        return this.ping;
    }

    void setPing(long ping) {
        this.ping = ping;
    }

    @Override
    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    @Override
    public PlayerSettings getPlayerSettings() {
        return this.settings == null ? ClientSettingsWrapper.DEFAULT : this.settings;
    }

    void setPlayerSettings(ClientSettings settings) {
        ClientSettingsWrapper cs = new ClientSettingsWrapper(settings);
        this.settings = cs;
        this.server.getEventManager().fireAndForget(new PlayerSettingsChangedEvent(this, cs));
    }

    @Override
    public Optional<ModInfo> getModInfo() {
        return Optional.ofNullable(this.modInfo);
    }

    public void setModInfo(ModInfo modInfo) {
        this.modInfo = modInfo;
        this.server.getEventManager().fireAndForget(new PlayerModInfoEvent(this, modInfo));
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.connection.getRemoteAddress();
    }

    @Override
    public Optional<InetSocketAddress> getVirtualHost() {
        return Optional.ofNullable(this.virtualHost);
    }

    void setPermissionFunction(PermissionFunction permissionFunction) {
        this.permissionFunction = permissionFunction;
    }

    @Override
    public boolean isActive() {
        return this.connection.getChannel().isActive();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.connection.getProtocolVersion();
    }

    public Component translateMessage(Component message) {
        Locale locale = ClosestLocaleMatcher.INSTANCE.lookupClosest(this.getEffectiveLocale() == null ? Locale.getDefault() : this.getEffectiveLocale());
        return GlobalTranslator.render(message, locale);
    }

    @Override
    public void sendMessage(@NonNull Identity identity, @NonNull Component message) {
        Component translated = this.translateMessage(message);
        this.connection.write(Chat.createClientbound(identity, translated, this.getProtocolVersion()));
    }

    @Override
    public void sendMessage(@NonNull Identity identity, @NonNull Component message, @NonNull MessageType type) {
        Preconditions.checkNotNull(message, "message");
        Preconditions.checkNotNull(type, "type");
        Component translated = this.translateMessage(message);
        Chat packet = Chat.createClientbound(identity, translated, this.getProtocolVersion());
        packet.setType(type == MessageType.CHAT ? (byte)0 : 1);
        this.connection.write(packet);
    }

    @Override
    public void sendActionBar(@NonNull Component message) {
        Component translated = this.translateMessage(message);
        ProtocolVersion playerVersion = this.getProtocolVersion();
        if (playerVersion.compareTo(ProtocolVersion.MINECRAFT_1_11) >= 0) {
            GenericTitlePacket pkt = GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.SET_ACTION_BAR, playerVersion);
            pkt.setComponent((String)ProtocolUtils.getJsonChatSerializer(playerVersion).serialize(translated));
            this.connection.write(pkt);
        } else {
            JsonObject object = new JsonObject();
            object.addProperty("text", LegacyComponentSerializer.legacySection().serialize(translated));
            Chat chat = new Chat();
            chat.setMessage(object.toString());
            chat.setType((byte)2);
            this.connection.write(chat);
        }
    }

    @Override
    public Component getPlayerListHeader() {
        return this.playerListHeader;
    }

    @Override
    public Component getPlayerListFooter() {
        return this.playerListFooter;
    }

    @Override
    public void sendPlayerListHeader(@NonNull Component header) {
        this.sendPlayerListHeaderAndFooter(header, this.playerListFooter);
    }

    @Override
    public void sendPlayerListFooter(@NonNull Component footer) {
        this.sendPlayerListHeaderAndFooter(this.playerListHeader, footer);
    }

    @Override
    public void sendPlayerListHeaderAndFooter(Component header, Component footer) {
        Component translatedHeader = this.translateMessage(header);
        Component translatedFooter = this.translateMessage(footer);
        this.playerListHeader = translatedHeader;
        this.playerListFooter = translatedFooter;
        if (this.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            this.connection.write(HeaderAndFooter.create(header, footer, this.getProtocolVersion()));
        }
    }

    @Override
    public void showTitle(@NonNull Title title) {
        if (this.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            GsonComponentSerializer serializer = ProtocolUtils.getJsonChatSerializer(this.getProtocolVersion());
            GenericTitlePacket timesPkt = GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.SET_TIMES, this.getProtocolVersion());
            Title.Times times = title.times();
            if (times != null) {
                timesPkt.setFadeIn((int)DurationUtils.toTicks(times.fadeIn()));
                timesPkt.setStay((int)DurationUtils.toTicks(times.stay()));
                timesPkt.setFadeOut((int)DurationUtils.toTicks(times.fadeOut()));
            }
            this.connection.delayedWrite(timesPkt);
            GenericTitlePacket subtitlePkt = GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.SET_SUBTITLE, this.getProtocolVersion());
            subtitlePkt.setComponent((String)serializer.serialize(this.translateMessage(title.subtitle())));
            this.connection.delayedWrite(subtitlePkt);
            GenericTitlePacket titlePkt = GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.SET_TITLE, this.getProtocolVersion());
            titlePkt.setComponent((String)serializer.serialize(this.translateMessage(title.title())));
            this.connection.delayedWrite(titlePkt);
            this.connection.flush();
        }
    }

    @Override
    public <T> void sendTitlePart(@NotNull TitlePart<T> part, @NotNull T value) {
        if (part == null) {
            throw new NullPointerException("part");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (this.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_8) < 0) {
            return;
        }
        GsonComponentSerializer serializer = ProtocolUtils.getJsonChatSerializer(this.getProtocolVersion());
        if (part == TitlePart.TITLE) {
            GenericTitlePacket titlePkt = GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.SET_TITLE, this.getProtocolVersion());
            titlePkt.setComponent((String)serializer.serialize(this.translateMessage((Component)value)));
            this.connection.write(titlePkt);
        } else if (part == TitlePart.SUBTITLE) {
            GenericTitlePacket titlePkt = GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.SET_SUBTITLE, this.getProtocolVersion());
            titlePkt.setComponent((String)serializer.serialize(this.translateMessage((Component)value)));
            this.connection.write(titlePkt);
        } else if (part == TitlePart.TIMES) {
            Title.Times times = (Title.Times)value;
            GenericTitlePacket timesPkt = GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.SET_TIMES, this.getProtocolVersion());
            timesPkt.setFadeIn((int)DurationUtils.toTicks(times.fadeIn()));
            timesPkt.setStay((int)DurationUtils.toTicks(times.stay()));
            timesPkt.setFadeOut((int)DurationUtils.toTicks(times.fadeOut()));
            this.connection.write(timesPkt);
        } else {
            throw new IllegalArgumentException("Title part " + part + " is not valid");
        }
    }

    @Override
    public void clearTitle() {
        if (this.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            this.connection.write(GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.HIDE, this.getProtocolVersion()));
        }
    }

    @Override
    public void resetTitle() {
        if (this.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            this.connection.write(GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.RESET, this.getProtocolVersion()));
        }
    }

    @Override
    public void hideBossBar(@NonNull BossBar bar) {
        if (this.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_9) >= 0) {
            this.server.getBossBarManager().removeBossBar(this, bar);
        }
    }

    @Override
    public void showBossBar(@NonNull BossBar bar) {
        if (this.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_9) >= 0) {
            this.server.getBossBarManager().addBossBar(this, bar);
        }
    }

    @Override
    public ConnectionRequestBuilder createConnectionRequest(RegisteredServer server) {
        return new ConnectionRequestBuilderImpl(server);
    }

    @Override
    public List<GameProfile.Property> getGameProfileProperties() {
        return this.profile.getProperties();
    }

    @Override
    public void setGameProfileProperties(List<GameProfile.Property> properties) {
        this.profile = this.profile.withProperties(Preconditions.checkNotNull(properties));
    }

    @Override
    public void clearHeaderAndFooter() {
        this.tabList.clearHeaderAndFooter();
    }

    @Override
    public VelocityTabList getTabList() {
        return this.tabList;
    }

    @Override
    public void disconnect(Component reason) {
        if (this.connection.eventLoop().inEventLoop()) {
            this.disconnect0(reason, false);
        } else {
            this.connection.eventLoop().execute(() -> this.disconnect0(reason, false));
        }
    }

    public void disconnect0(Component reason, boolean duringLogin) {
        Component translated = this.translateMessage(reason);
        logger.info("{} has disconnected: {}", (Object)this, (Object)LegacyComponentSerializer.legacySection().serialize(translated));
        this.connection.closeWith(Disconnect.create(translated, this.getProtocolVersion()));
    }

    public @Nullable VelocityServerConnection getConnectedServer() {
        return this.connectedServer;
    }

    public @Nullable VelocityServerConnection getConnectionInFlight() {
        return this.connectionInFlight;
    }

    public void resetInFlightConnection() {
        this.connectionInFlight = null;
    }

    public void handleConnectionException(RegisteredServer server, Throwable throwable, boolean safe) {
        TranslatableComponent friendlyError;
        Throwable cause;
        if (!this.isActive()) {
            return;
        }
        if (throwable == null) {
            throw new NullPointerException("throwable");
        }
        Throwable wrapped = throwable;
        if (throwable instanceof CompletionException && (cause = throwable.getCause()) != null) {
            wrapped = cause;
        }
        if (this.connectedServer != null && this.connectedServer.getServerInfo().equals(server.getServerInfo())) {
            friendlyError = Component.translatable("velocity.error.connected-server-error", Component.text(server.getServerInfo().getName()));
        } else {
            logger.error("{}: unable to connect to server {}", (Object)this, (Object)server.getServerInfo().getName(), (Object)wrapped);
            friendlyError = Component.translatable("velocity.error.connecting-server-error", Component.text(server.getServerInfo().getName()));
        }
        this.handleConnectionException(server, null, friendlyError.color(NamedTextColor.RED), safe);
    }

    public void handleConnectionException(RegisteredServer server, Disconnect disconnect, boolean safe) {
        if (!this.isActive()) {
            return;
        }
        Object disconnectReason = GsonComponentSerializer.gson().deserialize(disconnect.getReason());
        String plainTextReason = PASS_THRU_TRANSLATE.serialize((Component)disconnectReason);
        if (this.connectedServer != null && this.connectedServer.getServerInfo().equals(server.getServerInfo())) {
            logger.info("{}: kicked from server {}: {}", (Object)this, (Object)server.getServerInfo().getName(), (Object)plainTextReason);
            this.handleConnectionException(server, (Component)disconnectReason, Component.translatable("velocity.error.moved-to-new-server", (TextColor)NamedTextColor.RED, new ComponentLike[]{Component.text(server.getServerInfo().getName()), disconnectReason}), safe);
        } else {
            logger.error("{}: disconnected while connecting to {}: {}", (Object)this, (Object)server.getServerInfo().getName(), (Object)plainTextReason);
            this.handleConnectionException(server, (Component)disconnectReason, Component.translatable("velocity.error.cant-connect", (TextColor)NamedTextColor.RED, new ComponentLike[]{Component.text(server.getServerInfo().getName()), disconnectReason}), safe);
        }
    }

    private void handleConnectionException(RegisteredServer rs, @Nullable Component kickReason, Component friendlyReason, boolean safe) {
        KickedFromServerEvent.ServerKickResult result;
        boolean kickedFromCurrent;
        if (!this.isActive()) {
            return;
        }
        if (!safe) {
            this.disconnect(friendlyReason);
            return;
        }
        boolean bl = kickedFromCurrent = this.connectedServer == null || this.connectedServer.getServer().equals(rs);
        if (kickedFromCurrent) {
            Optional<RegisteredServer> next = this.getNextServerToTry(rs);
            result = next.map(KickedFromServerEvent.RedirectPlayer::create).orElseGet(() -> KickedFromServerEvent.DisconnectPlayer.create(friendlyReason));
        } else {
            if (this.connectionInFlight != null && this.connectionInFlight.getServer().equals(rs)) {
                this.resetInFlightConnection();
            }
            result = KickedFromServerEvent.Notify.create(friendlyReason);
        }
        KickedFromServerEvent originalEvent = new KickedFromServerEvent(this, rs, kickReason, !kickedFromCurrent, result);
        this.handleKickEvent(originalEvent, friendlyReason, kickedFromCurrent);
    }

    private void handleKickEvent(KickedFromServerEvent originalEvent, Component friendlyReason, boolean kickedFromCurrent) {
        this.server.getEventManager().fire(originalEvent).thenAcceptAsync(event -> {
            boolean previouslyConnected;
            this.connectionInFlight = null;
            boolean bl = previouslyConnected = this.connectedServer != null;
            if (kickedFromCurrent) {
                this.connectedServer = null;
            }
            if (!this.isActive()) {
                return;
            }
            if (event.getResult() instanceof KickedFromServerEvent.DisconnectPlayer) {
                KickedFromServerEvent.DisconnectPlayer res = (KickedFromServerEvent.DisconnectPlayer)event.getResult();
                this.disconnect(res.getReasonComponent());
            } else if (event.getResult() instanceof KickedFromServerEvent.RedirectPlayer) {
                KickedFromServerEvent.RedirectPlayer res = (KickedFromServerEvent.RedirectPlayer)event.getResult();
                this.createConnectionRequest(res.getServer()).connect().whenCompleteAsync((status, throwable) -> {
                    if (throwable != null) {
                        this.handleConnectionException(status != null ? status.getAttemptedConnection() : res.getServer(), (Throwable)throwable, true);
                        return;
                    }
                    switch (status.getStatus()) {
                        case ALREADY_CONNECTED: 
                        case CONNECTION_IN_PROGRESS: 
                        case CONNECTION_CANCELLED: {
                            Component fallbackMsg = res.getMessageComponent();
                            if (fallbackMsg == null) {
                                fallbackMsg = friendlyReason;
                            }
                            this.disconnect(status.getReasonComponent().orElse(fallbackMsg));
                            break;
                        }
                        case SERVER_DISCONNECTED: {
                            Component reason = status.getReasonComponent().orElse(ConnectionMessages.INTERNAL_SERVER_CONNECTION_ERROR);
                            this.handleConnectionException(res.getServer(), Disconnect.create(reason, this.getProtocolVersion()), ((ConnectionRequestResults.Impl)status).isSafe());
                            break;
                        }
                        case SUCCESS: {
                            Component requestedMessage = res.getMessageComponent();
                            if (requestedMessage == null) {
                                requestedMessage = friendlyReason;
                            }
                            if (requestedMessage == Component.empty()) break;
                            this.sendMessage(requestedMessage);
                            break;
                        }
                    }
                }, (Executor)this.connection.eventLoop());
            } else if (event.getResult() instanceof KickedFromServerEvent.Notify) {
                KickedFromServerEvent.Notify res = (KickedFromServerEvent.Notify)event.getResult();
                if (event.kickedDuringServerConnect() && previouslyConnected) {
                    this.sendMessage(Identity.nil(), res.getMessageComponent());
                } else {
                    this.disconnect(res.getMessageComponent());
                }
            } else {
                this.disconnect(friendlyReason);
            }
        }, (Executor)this.connection.eventLoop());
    }

    public Optional<RegisteredServer> getNextServerToTry() {
        return this.getNextServerToTry(null);
    }

    private Optional<RegisteredServer> getNextServerToTry(@Nullable RegisteredServer current) {
        if (this.serversToTry == null) {
            String virtualHostStr = this.getVirtualHost().map(InetSocketAddress::getHostString).orElse("").toLowerCase(Locale.ROOT);
            this.serversToTry = this.server.getConfiguration().getForcedHosts().getOrDefault(virtualHostStr, Collections.emptyList());
        }
        if (this.serversToTry.isEmpty()) {
            List<String> connOrder = this.server.getConfiguration().getAttemptConnectionOrder();
            if (connOrder.isEmpty()) {
                return Optional.empty();
            }
            this.serversToTry = connOrder;
        }
        for (int i = this.tryIndex; i < this.serversToTry.size(); ++i) {
            String toTryName = this.serversToTry.get(i);
            if (this.connectedServer != null && ConnectedPlayer.hasSameName(this.connectedServer.getServer(), toTryName) || this.connectionInFlight != null && ConnectedPlayer.hasSameName(this.connectionInFlight.getServer(), toTryName) || current != null && ConnectedPlayer.hasSameName(current, toTryName)) continue;
            this.tryIndex = i;
            return this.server.getServer(toTryName);
        }
        return Optional.empty();
    }

    private static boolean hasSameName(RegisteredServer server, String name) {
        return server.getServerInfo().getName().equalsIgnoreCase(name);
    }

    public void setConnectedServer(@Nullable VelocityServerConnection serverConnection) {
        this.connectedServer = serverConnection;
        this.tryIndex = 0;
        if (serverConnection == this.connectionInFlight) {
            this.connectionInFlight = null;
        }
    }

    public void sendLegacyForgeHandshakeResetPacket() {
        this.connectionPhase.resetConnectionPhase(this);
    }

    private MinecraftConnection ensureBackendConnection() {
        VelocityServerConnection sc = this.connectedServer;
        if (sc == null) {
            throw new IllegalStateException("No backend connection");
        }
        MinecraftConnection mc = sc.getConnection();
        if (mc == null) {
            throw new IllegalStateException("Backend connection is not connected to a server");
        }
        return mc;
    }

    void teardown() {
        if (this.connectionInFlight != null) {
            this.connectionInFlight.disconnect();
        }
        if (this.connectedServer != null) {
            this.connectedServer.disconnect();
        }
        Optional<Player> connectedPlayer = this.server.getPlayer(this.getUniqueId());
        this.server.unregisterConnection(this);
        DisconnectEvent.LoginStatus status = connectedPlayer.isPresent() ? (!connectedPlayer.get().getCurrentServer().isPresent() ? DisconnectEvent.LoginStatus.PRE_SERVER_JOIN : (connectedPlayer.get() == this ? DisconnectEvent.LoginStatus.SUCCESSFUL_LOGIN : DisconnectEvent.LoginStatus.CONFLICTING_LOGIN)) : (this.connection.isKnownDisconnect() ? DisconnectEvent.LoginStatus.CANCELLED_BY_PROXY : DisconnectEvent.LoginStatus.CANCELLED_BY_USER);
        DisconnectEvent event = new DisconnectEvent(this, status);
        this.server.getEventManager().fire(event).whenComplete((val, ex) -> {
            if (ex == null) {
                this.teardownFuture.complete(null);
            } else {
                this.teardownFuture.completeExceptionally((Throwable)ex);
            }
        });
    }

    public CompletableFuture<Void> getTeardownFuture() {
        return this.teardownFuture;
    }

    public String toString() {
        return "[connected player] " + this.profile.getName() + " (" + this.getRemoteAddress() + ")";
    }

    @Override
    public Tristate getPermissionValue(String permission) {
        return this.permissionFunction.getPermissionValue(permission);
    }

    @Override
    public boolean sendPluginMessage(ChannelIdentifier identifier, byte[] data) {
        Preconditions.checkNotNull(identifier, "identifier");
        Preconditions.checkNotNull(data, "data");
        PluginMessage message = new PluginMessage(identifier.getId(), Unpooled.wrappedBuffer(data));
        this.connection.write(message);
        return true;
    }

    @Override
    public String getClientBrand() {
        return this.clientBrand;
    }

    void setClientBrand(String clientBrand) {
        this.clientBrand = clientBrand;
    }

    @Override
    public void spoofChatInput(String input) {
        Preconditions.checkArgument(input.length() <= 256, "input cannot be greater than 256 characters in length");
        this.ensureBackendConnection().write(Chat.createServerbound(input));
    }

    @Override
    @Deprecated
    public void sendResourcePack(String url) {
        this.sendResourcePackOffer(new VelocityResourcePackInfo.BuilderImpl(url).build());
    }

    @Override
    @Deprecated
    public void sendResourcePack(String url, byte[] hash) {
        this.sendResourcePackOffer(new VelocityResourcePackInfo.BuilderImpl(url).setHash(hash).build());
    }

    @Override
    public void sendResourcePackOffer(ResourcePackInfo packInfo) {
        if (this.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            Preconditions.checkNotNull(packInfo, "packInfo");
            this.queueResourcePack(packInfo);
        }
    }

    public void queueResourcePack(ResourcePackInfo info) {
        this.outstandingResourcePacks.add(info);
        if (this.outstandingResourcePacks.size() == 1) {
            this.tickResourcePackQueue();
        }
    }

    private void tickResourcePackQueue() {
        ResourcePackInfo queued = this.outstandingResourcePacks.peek();
        if (queued != null) {
            if (this.previousResourceResponse != null && !this.previousResourceResponse.booleanValue()) {
                while (!(this.outstandingResourcePacks.isEmpty() || (queued = this.outstandingResourcePacks.peek()).getShouldForce() && this.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_17) >= 0)) {
                    this.onResourcePackResponse(PlayerResourcePackStatusEvent.Status.DECLINED);
                    queued = null;
                }
                if (queued == null) {
                    return;
                }
            }
            ResourcePackRequest request = new ResourcePackRequest();
            request.setUrl(queued.getUrl());
            if (queued.getHash() != null) {
                request.setHash(ByteBufUtil.hexDump(queued.getHash()));
            } else {
                request.setHash("");
            }
            request.setRequired(queued.getShouldForce());
            request.setPrompt(queued.getPrompt());
            this.connection.write(request);
        }
    }

    @Override
    public @Nullable ResourcePackInfo getAppliedResourcePack() {
        return this.appliedResourcePack;
    }

    @Override
    public @Nullable ResourcePackInfo getPendingResourcePack() {
        return this.pendingResourcePack;
    }

    public boolean onResourcePackResponse(PlayerResourcePackStatusEvent.Status status) {
        boolean peek = status == PlayerResourcePackStatusEvent.Status.ACCEPTED;
        ResourcePackInfo queued = peek ? this.outstandingResourcePacks.peek() : this.outstandingResourcePacks.poll();
        this.server.getEventManager().fire(new PlayerResourcePackStatusEvent(this, status, queued)).thenAcceptAsync(event -> {
            if (event.getStatus() == PlayerResourcePackStatusEvent.Status.DECLINED && event.getPackInfo() != null && event.getPackInfo().getShouldForce() && (!event.isOverwriteKick() || event.getPlayer().getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_17) >= 0)) {
                event.getPlayer().disconnect(Component.translatable("multiplayer.requiredTexturePrompt.disconnect"));
            }
        });
        switch (status) {
            case ACCEPTED: {
                this.previousResourceResponse = true;
                this.pendingResourcePack = queued;
                break;
            }
            case DECLINED: {
                this.previousResourceResponse = false;
                break;
            }
            case SUCCESSFUL: {
                this.appliedResourcePack = queued;
                this.pendingResourcePack = null;
                break;
            }
            case FAILED_DOWNLOAD: {
                this.pendingResourcePack = null;
                break;
            }
        }
        if (!peek) {
            this.connection.eventLoop().execute(this::tickResourcePackQueue);
        }
        return queued != null && queued.getOrigin() == ResourcePackInfo.Origin.DOWNSTREAM_SERVER;
    }

    public void sendKeepAlive() {
        if (this.connection.getState() == StateRegistry.PLAY) {
            KeepAlive keepAlive = new KeepAlive();
            keepAlive.setRandomId(ThreadLocalRandom.current().nextLong());
            this.connection.write(keepAlive);
        }
    }

    public ClientConnectionPhase getPhase() {
        return this.connectionPhase;
    }

    public void setPhase(ClientConnectionPhase connectionPhase) {
        this.connectionPhase = connectionPhase;
    }

    public Collection<String> getKnownChannels() {
        return this.knownChannels;
    }

    private class ConnectionRequestBuilderImpl
    implements ConnectionRequestBuilder {
        private final RegisteredServer toConnect;

        ConnectionRequestBuilderImpl(RegisteredServer toConnect) {
            this.toConnect = Preconditions.checkNotNull(toConnect, "info");
        }

        @Override
        public RegisteredServer getServer() {
            return this.toConnect;
        }

        private Optional<ConnectionRequestBuilder.Status> checkServer(RegisteredServer server) {
            Preconditions.checkArgument(server instanceof VelocityRegisteredServer, "Not a valid Velocity server.");
            if (ConnectedPlayer.this.connectionInFlight != null || ConnectedPlayer.this.connectedServer != null && !ConnectedPlayer.this.connectedServer.hasCompletedJoin()) {
                return Optional.of(ConnectionRequestBuilder.Status.CONNECTION_IN_PROGRESS);
            }
            if (ConnectedPlayer.this.connectedServer != null && ConnectedPlayer.this.connectedServer.getServer().getServerInfo().equals(server.getServerInfo())) {
                return Optional.of(ConnectionRequestBuilder.Status.ALREADY_CONNECTED);
            }
            return Optional.empty();
        }

        private CompletableFuture<Optional<ConnectionRequestBuilder.Status>> getInitialStatus() {
            return CompletableFuture.supplyAsync(() -> this.checkServer(this.toConnect), ConnectedPlayer.this.connection.eventLoop());
        }

        private CompletableFuture<ConnectionRequestResults.Impl> internalConnect() {
            return this.getInitialStatus().thenCompose(initialCheck -> {
                if (initialCheck.isPresent()) {
                    return CompletableFuture.completedFuture(ConnectionRequestResults.plainResult((ConnectionRequestBuilder.Status)((Object)((Object)initialCheck.get())), this.toConnect));
                }
                ServerPreConnectEvent event = new ServerPreConnectEvent(ConnectedPlayer.this, this.toConnect);
                return ConnectedPlayer.this.server.getEventManager().fire(event).thenComposeAsync(newEvent -> {
                    VelocityServerConnection con;
                    Optional<RegisteredServer> newDest = newEvent.getResult().getServer();
                    if (!newDest.isPresent()) {
                        return CompletableFuture.completedFuture(ConnectionRequestResults.plainResult(ConnectionRequestBuilder.Status.CONNECTION_CANCELLED, this.toConnect));
                    }
                    RegisteredServer realDestination = newDest.get();
                    Optional<ConnectionRequestBuilder.Status> check = this.checkServer(realDestination);
                    if (check.isPresent()) {
                        return CompletableFuture.completedFuture(ConnectionRequestResults.plainResult(check.get(), realDestination));
                    }
                    VelocityRegisteredServer vrs = (VelocityRegisteredServer)realDestination;
                    ConnectedPlayer.this.connectionInFlight = con = new VelocityServerConnection(vrs, ConnectedPlayer.this, ConnectedPlayer.this.server);
                    return con.connect().whenCompleteAsync((result, exception) -> this.resetIfInFlightIs(con), (Executor)ConnectedPlayer.this.connection.eventLoop());
                }, (Executor)ConnectedPlayer.this.connection.eventLoop());
            });
        }

        private void resetIfInFlightIs(VelocityServerConnection establishedConnection) {
            if (establishedConnection == ConnectedPlayer.this.connectionInFlight) {
                ConnectedPlayer.this.resetInFlightConnection();
            }
        }

        @Override
        public CompletableFuture<ConnectionRequestBuilder.Result> connect() {
            return ((CompletableFuture)this.internalConnect().whenCompleteAsync((status, throwable) -> {
                if (status != null && !status.isSuccessful() && !status.isSafe()) {
                    ConnectedPlayer.this.handleConnectionException(status.getAttemptedConnection(), (Throwable)throwable, false);
                    return;
                }
                if (throwable != null) {
                    logger.error("Exception during connect; status = {}", status, throwable);
                }
            }, (Executor)ConnectedPlayer.this.connection.eventLoop())).thenApply(x -> x);
        }

        @Override
        public CompletableFuture<Boolean> connectWithIndication() {
            return ((CompletableFuture)this.internalConnect().whenCompleteAsync((status, throwable) -> {
                if (throwable != null) {
                    ConnectedPlayer.this.handleConnectionException(status != null ? status.getAttemptedConnection() : this.toConnect, (Throwable)throwable, true);
                    return;
                }
                switch (status.getStatus()) {
                    case ALREADY_CONNECTED: {
                        ConnectedPlayer.this.sendMessage(Identity.nil(), (Component)ConnectionMessages.ALREADY_CONNECTED);
                        break;
                    }
                    case CONNECTION_IN_PROGRESS: {
                        ConnectedPlayer.this.sendMessage(Identity.nil(), (Component)ConnectionMessages.IN_PROGRESS);
                        break;
                    }
                    case CONNECTION_CANCELLED: {
                        break;
                    }
                    case SERVER_DISCONNECTED: {
                        Component reason = status.getReasonComponent().orElse(ConnectionMessages.INTERNAL_SERVER_CONNECTION_ERROR);
                        ConnectedPlayer.this.handleConnectionException(this.toConnect, Disconnect.create(reason, ConnectedPlayer.this.getProtocolVersion()), status.isSafe());
                        break;
                    }
                }
            }, (Executor)ConnectedPlayer.this.connection.eventLoop())).thenApply(ConnectionRequestBuilder.Result::isSuccessful);
        }

        @Override
        public void fireAndForget() {
            this.connectWithIndication();
        }
    }

    private class IdentityImpl
    implements Identity {
        private IdentityImpl() {
        }

        @Override
        public @NonNull UUID uuid() {
            return ConnectedPlayer.this.getUniqueId();
        }
    }
}

